/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.graph.directed.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Queue;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.lsat.common.graph.directed.DirectedGraph;
import org.eclipse.lsat.common.graph.directed.Edge;
import org.eclipse.lsat.common.graph.directed.Node;
import org.eclipse.lsat.common.queries.QueryableIterable;

public final class DirectedGraphQueries {
    private DirectedGraphQueries() {
    }

    public static final <N extends Node, E extends Edge> Iterable<N> allSubNodes(DirectedGraph<N, E> graph) {
        return QueryableIterable.from((Object[])new DirectedGraph[]{graph}).closure(true, DirectedGraph::getSubGraphs).xcollect(DirectedGraph::getNodes);
    }

    public static final <N extends Node> EList<N> topologicalOrdering(Iterable<N> nodes) {
        return DirectedGraphQueries.topologicalOrdering(nodes, new LinkedList());
    }

    public static final <N extends Node> EList<N> topologicalOrdering(Iterable<N> nodes, Comparator<? super N> preference) {
        return DirectedGraphQueries.topologicalOrdering(nodes, new PriorityQueue<N>(11, preference));
    }

    private static final <N extends Node> EList<N> topologicalOrdering(Iterable<N> nodes, Queue<N> nodesWithoutIncomingEdges) {
        assert (nodesWithoutIncomingEdges.isEmpty()) : "Expected an empty queue";
        HashMap<Node, Integer> notVisitedIncomingEdges = new HashMap<Node, Integer>();
        for (Node node : nodes) {
            int incomingEdgesSize = node.getIncomingEdges().size();
            notVisitedIncomingEdges.put(node, incomingEdgesSize);
            if (incomingEdgesSize != 0) continue;
            nodesWithoutIncomingEdges.add(node);
        }
        BasicEList topologicalOrder = new BasicEList(notVisitedIncomingEdges.size());
        while (!nodesWithoutIncomingEdges.isEmpty()) {
            Node node = (Node)nodesWithoutIncomingEdges.remove();
            topologicalOrder.add((Object)node);
            for (Edge outgoingEdge : node.getOutgoingEdges()) {
                Node sucessor = outgoingEdge.getTargetNode();
                Integer notVisitedIncomingEdgesSize = (Integer)notVisitedIncomingEdges.get(sucessor);
                if (notVisitedIncomingEdgesSize == null) continue;
                notVisitedIncomingEdgesSize = notVisitedIncomingEdgesSize - 1;
                notVisitedIncomingEdges.put(sucessor, notVisitedIncomingEdgesSize);
                if (notVisitedIncomingEdgesSize != 0) continue;
                nodesWithoutIncomingEdges.add(sucessor);
            }
        }
        if (topologicalOrder.size() != notVisitedIncomingEdges.size()) {
            return null;
        }
        return topologicalOrder;
    }

    public static final <N extends Node> EList<N> reverseTopologicalOrdering(Iterable<N> nodes) {
        return DirectedGraphQueries.reverseTopologicalOrdering(nodes, new LinkedList());
    }

    public static final <N extends Node> EList<N> reverseTopologicalOrdering(Iterable<N> nodes, Comparator<? super N> preference) {
        return DirectedGraphQueries.reverseTopologicalOrdering(nodes, new PriorityQueue<N>(11, preference));
    }

    private static final <N extends Node> EList<N> reverseTopologicalOrdering(Iterable<N> nodes, Queue<N> nodesWithoutOutgoingEdges) {
        assert (nodesWithoutOutgoingEdges.isEmpty()) : "Expected an empty queue";
        HashMap<Node, Integer> notVisitedOutgoingEdges = new HashMap<Node, Integer>();
        for (Node node : nodes) {
            int outgoingEdgesSize = node.getOutgoingEdges().size();
            notVisitedOutgoingEdges.put(node, outgoingEdgesSize);
            if (outgoingEdgesSize != 0) continue;
            nodesWithoutOutgoingEdges.add(node);
        }
        BasicEList reverseTopologicalOrder = new BasicEList(notVisitedOutgoingEdges.size());
        while (!nodesWithoutOutgoingEdges.isEmpty()) {
            Node node = (Node)nodesWithoutOutgoingEdges.remove();
            reverseTopologicalOrder.add((Object)node);
            for (Edge incomingEdge : node.getIncomingEdges()) {
                Node predecessor = incomingEdge.getSourceNode();
                Integer notVisitedOutgoingEdgesSize = (Integer)notVisitedOutgoingEdges.get(predecessor);
                if (notVisitedOutgoingEdgesSize == null) continue;
                notVisitedOutgoingEdgesSize = notVisitedOutgoingEdgesSize - 1;
                notVisitedOutgoingEdges.put(predecessor, notVisitedOutgoingEdgesSize);
                if (notVisitedOutgoingEdgesSize != 0) continue;
                nodesWithoutOutgoingEdges.add(predecessor);
            }
        }
        if (reverseTopologicalOrder.size() != notVisitedOutgoingEdges.size()) {
            return null;
        }
        return reverseTopologicalOrder;
    }
}

