/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.xtend.annotations;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.lsat.common.xtend.annotations.Resolvable;
import org.eclipse.lsat.common.xtend.annotations.TypeReferenceUtil;
import org.eclipse.xtend.lib.macro.AbstractMethodProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ResolvableCompilationParticipant
extends AbstractMethodProcessor {
    public void doTransform(final MutableMethodDeclaration annotatedMethod, @Extension TransformationContext context) {
        boolean _equals;
        boolean _not;
        MutableTypeDeclaration _declaringType = annotatedMethod.getDeclaringType();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("_createCache_");
        String _simpleName = annotatedMethod.getSimpleName();
        _builder.append(_simpleName);
        final MutableFieldDeclaration createCache = _declaringType.findDeclaredField(_builder.toString());
        if (createCache == null) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("@Resolvable can only be used on create methods.");
            context.addError((Element)annotatedMethod, _builder_1.toString());
            return;
        }
        boolean _isInferred = annotatedMethod.getReturnType().isInferred();
        if (_isInferred) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Please specify an explicit return type for @Resolvable methods");
            context.addError((Element)annotatedMethod, _builder_2.toString());
            return;
        }
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)annotatedMethod.getParameters());
        if (_isEmpty) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("At least 1 parameter is required for @Resolvable methods.");
            context.addError((Element)annotatedMethod, _builder_3.toString());
            return;
        }
        MutableTypeDeclaration _declaringType_1 = annotatedMethod.getDeclaringType();
        boolean bl = _not = !(_declaringType_1 instanceof MutableClassDeclaration);
        if (_not) {
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("@Resolvable methods should be declared on class.");
            context.addError((Element)annotatedMethod, _builder_4.toString());
            return;
        }
        MutableTypeDeclaration _declaringType_2 = annotatedMethod.getDeclaringType();
        MutableClassDeclaration declaringClass = (MutableClassDeclaration)_declaringType_2;
        int _length = ((Object[])Conversions.unwrapArray((Object)annotatedMethod.getParameters(), Object.class)).length;
        boolean bl2 = _equals = _length == 1;
        if (_equals) {
            final MutableParameterDeclaration sourceParameter = (MutableParameterDeclaration)IterableExtensions.head((Iterable)annotatedMethod.getParameters());
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("_resolveOne_");
            String _simpleName_1 = annotatedMethod.getSimpleName();
            _builder_5.append(_simpleName_1);
            Procedures.Procedure1 _function = it -> {
                it.setVisibility(Visibility.PRIVATE);
                it.setReturnType(context.newTypeReference(Optional.class, new TypeReference[]{annotatedMethod.getReturnType()}));
                it.addParameter(sourceParameter.getSimpleName(), sourceParameter.getType());
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"final ArrayList<?> _cacheKey = CollectionLiterals.newArrayList(");
                        String _simpleName = sourceParameter.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"synchronized (");
                        String _simpleName_1 = createCache.getSimpleName();
                        _builder.append((Object)_simpleName_1);
                        _builder.append((Object)") {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"    ");
                        _builder.append((Object)"if (");
                        String _simpleName_2 = createCache.getSimpleName();
                        _builder.append((Object)_simpleName_2, "    ");
                        _builder.append((Object)".containsKey(_cacheKey)) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"        ");
                        _builder.append((Object)"return Optional.ofNullable(");
                        String _simpleName_3 = createCache.getSimpleName();
                        _builder.append((Object)_simpleName_3, "        ");
                        _builder.append((Object)".get(_cacheKey));");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"    ");
                        _builder.append((Object)"} else {");
                        _builder.newLine();
                        _builder.append((Object)"        ");
                        _builder.append((Object)"return Optional.empty();");
                        _builder.newLine();
                        _builder.append((Object)"    ");
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"}");
                        _builder.newLine();
                    }
                };
                it.setBody(_client);
            };
            declaringClass.addMethod(_builder_5.toString(), _function);
            StringConcatenation _builder_6 = new StringConcatenation();
            _builder_6.append("_resolveAll_");
            String _simpleName_2 = annotatedMethod.getSimpleName();
            _builder_6.append(_simpleName_2);
            Procedures.Procedure1 _function_1 = it -> {
                it.setVisibility(Visibility.PRIVATE);
                it.setReturnType(context.newTypeReference(Stream.class, new TypeReference[]{annotatedMethod.getReturnType()}));
                it.addParameter(sourceParameter.getSimpleName(), sourceParameter.getType());
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"final Optional<");
                        TypeReference _returnType = annotatedMethod.getReturnType();
                        _builder.append((Object)_returnType);
                        _builder.append((Object)"> resolved = _resolveOne_");
                        String _simpleName = annotatedMethod.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)"(");
                        String _simpleName_1 = sourceParameter.getSimpleName();
                        _builder.append((Object)_simpleName_1);
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"return Stream.of(resolved).filter(Optional::isPresent).map(Optional::get);");
                        _builder.newLine();
                    }
                };
                it.setBody(_client);
            };
            declaringClass.addMethod(_builder_6.toString(), _function_1);
        } else {
            Functions.Function1 _function_2 = it -> it.getType();
            Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)annotatedMethod.getParameters(), (Functions.Function1)_function_2));
            for (TypeReference sourceParameterType : _set) {
                StringConcatenation _builder_7 = new StringConcatenation();
                _builder_7.append("_resolveOne_");
                String _simpleName_3 = annotatedMethod.getSimpleName();
                _builder_7.append(_simpleName_3);
                Procedures.Procedure1 _function_3 = it -> {
                    it.setVisibility(Visibility.PRIVATE);
                    it.setReturnType(context.newTypeReference(Optional.class, new TypeReference[]{annotatedMethod.getReturnType()}));
                    it.addParameter("source", sourceParameterType);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"return _resolveAll_events2Dependency(source).findAny();");
                        }
                    };
                    it.setBody(_client);
                };
                declaringClass.addMethod(_builder_7.toString(), _function_3);
                StringConcatenation _builder_8 = new StringConcatenation();
                _builder_8.append("_resolveAll_");
                String _simpleName_4 = annotatedMethod.getSimpleName();
                _builder_8.append(_simpleName_4);
                Procedures.Procedure1 _function_4 = it -> {
                    it.setVisibility(Visibility.PRIVATE);
                    it.setReturnType(context.newTypeReference(Stream.class, new TypeReference[]{annotatedMethod.getReturnType()}));
                    it.addParameter("source", sourceParameterType);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"// TODO what about synchronization here?");
                            _builder.newLine();
                            _builder.append((Object)"return ");
                            String _simpleName = createCache.getSimpleName();
                            _builder.append((Object)_simpleName);
                            _builder.append((Object)".entrySet().stream().filter(e -> e.getKey().contains(source)).map(java.util.Map.Entry::getValue);");
                            _builder.newLineIfNotEmpty();
                        }
                    };
                    it.setBody(_client);
                };
                declaringClass.addMethod(_builder_8.toString(), _function_4);
            }
        }
        StringConcatenation _builder_7 = new StringConcatenation();
        _builder_7.append("_invResolveOne_");
        String _simpleName_3 = annotatedMethod.getSimpleName();
        _builder_7.append(_simpleName_3);
        Procedures.Procedure1 _function_3 = it -> {
            TypeReference genericType = context.newTypeReference((Type)it.addTypeParameter("T", new TypeReference[0]), new TypeReference[0]);
            TypeReference resolveType = context.newTypeReference(Class.class, new TypeReference[]{genericType});
            it.setVisibility(Visibility.PRIVATE);
            it.setReturnType(context.newTypeReference(Optional.class, new TypeReference[]{genericType}));
            it.addParameter("target", annotatedMethod.getReturnType());
            it.addParameter("typeToResolve", resolveType);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return _invResolveAll_");
                    String _simpleName = annotatedMethod.getSimpleName();
                    _builder.append((Object)_simpleName);
                    _builder.append((Object)"(target, typeToResolve).findFirst();");
                }
            };
            it.setBody(_client);
        };
        declaringClass.addMethod(_builder_7.toString(), _function_3);
        StringConcatenation _builder_8 = new StringConcatenation();
        _builder_8.append("_invResolveAll_");
        String _simpleName_4 = annotatedMethod.getSimpleName();
        _builder_8.append(_simpleName_4);
        Procedures.Procedure1 _function_4 = it -> {
            TypeReference genericType = context.newTypeReference((Type)it.addTypeParameter("T", new TypeReference[0]), new TypeReference[0]);
            TypeReference resolveType = context.newTypeReference(Class.class, new TypeReference[]{genericType});
            it.setVisibility(Visibility.PRIVATE);
            it.setReturnType(context.newTypeReference(Stream.class, new TypeReference[]{genericType}));
            it.addParameter("target", annotatedMethod.getReturnType());
            it.addParameter("typeToResolve", resolveType);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"// TODO what about synchronization here?");
                    _builder.newLine();
                    _builder.append((Object)"return ");
                    String _simpleName = createCache.getSimpleName();
                    _builder.append((Object)_simpleName);
                    _builder.append((Object)".entrySet().stream().filter(e -> e.getValue() == target)");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"        ");
                    _builder.append((Object)".flatMap(e -> e.getKey().stream()).filter(typeToResolve::isInstance).map(typeToResolve::cast);");
                    _builder.newLine();
                }
            };
            it.setBody(_client);
        };
        declaringClass.addMethod(_builder_8.toString(), _function_4);
        this.doTransform(declaringClass, context);
    }

    public void doTransform(MutableClassDeclaration declaringClass, @Extension TransformationContext context) {
        Functions.Function1 _function = it -> {
            String _simpleName = it.getSimpleName();
            return Objects.equals(_simpleName, "resolveOne");
        };
        boolean _exists = IterableExtensions.exists((Iterable)declaringClass.getDeclaredMethods(), (Functions.Function1)_function);
        if (_exists) {
            return;
        }
        Type annotationType = context.findTypeGlobally(Resolvable.class);
        Functions.Function1 _function_1 = it -> {
            AnnotationReference _findAnnotation = it.findAnnotation(annotationType);
            return _findAnnotation != null;
        };
        Iterable annotatedMethods = IterableExtensions.filter((Iterable)declaringClass.getDeclaredMethods(), (Functions.Function1)_function_1);
        LinkedHashMap sourceTypes = CollectionLiterals.newLinkedHashMap();
        LinkedHashMap targetTypes = CollectionLiterals.newLinkedHashMap();
        Consumer<MutableMethodDeclaration> _function_2 = method -> {
            Functions.Function1 _function_3 = it -> it.getType();
            Consumer<TypeReference> _function_4 = type -> {
                Function<TypeReference, LinkedHashSet> _function_5 = it -> CollectionLiterals.newLinkedHashSet();
                LinkedHashSet _computeIfAbsent = sourceTypes.computeIfAbsent(type, _function_5);
                _computeIfAbsent.add(method);
            };
            IterableExtensions.map((Iterable)method.getParameters(), (Functions.Function1)_function_3).forEach(_function_4);
            Function<TypeReference, LinkedHashSet> _function_5 = it -> CollectionLiterals.newLinkedHashSet();
            LinkedHashSet _computeIfAbsent = targetTypes.computeIfAbsent(method.getReturnType(), _function_5);
            _computeIfAbsent.add(method);
        };
        annotatedMethods.forEach(_function_2);
        BiConsumer<TypeReference, LinkedHashSet> _function_3 = (sourceType, annotatedMethodsForSourceType) -> {
            Procedures.Procedure1 _function_4 = it -> {
                TypeReference genericType = context.newTypeReference((Type)it.addTypeParameter("T", new TypeReference[0]), new TypeReference[0]);
                TypeReference resolveType = context.newTypeReference(Class.class, new TypeReference[]{genericType});
                MethodDeclaration superResolve = TypeReferenceUtil.findResolvedMethod(context.newTypeReference((Type)declaringClass, new TypeReference[0]), "resolveOne", sourceType, resolveType);
                it.setVisibility(Visibility.PROTECTED);
                it.setReturnType(genericType);
                it.addParameter("source", sourceType);
                it.addParameter("typeToResolve", resolveType);
                StringConcatenationClient _client = new StringConcatenationClient((LinkedHashSet)annotatedMethodsForSourceType, superResolve){
                    private final /* synthetic */ LinkedHashSet val$annotatedMethodsForSourceType;
                    private final /* synthetic */ MethodDeclaration val$superResolve;
                    {
                        this.val$annotatedMethodsForSourceType = linkedHashSet;
                        this.val$superResolve = methodDeclaration;
                    }

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        for (MutableMethodDeclaration annotatedMethod : this.val$annotatedMethodsForSourceType) {
                            _builder.append((Object)"if (typeToResolve.isAssignableFrom(");
                            String _simpleName = annotatedMethod.getReturnType().getType().getSimpleName();
                            _builder.append((Object)_simpleName);
                            _builder.append((Object)".class) || ");
                            String _simpleName_1 = annotatedMethod.getReturnType().getType().getSimpleName();
                            _builder.append((Object)_simpleName_1);
                            _builder.append((Object)".class.isAssignableFrom(typeToResolve)) {");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"final Optional<");
                            String _simpleName_2 = annotatedMethod.getReturnType().getSimpleName();
                            _builder.append((Object)_simpleName_2, "    ");
                            _builder.append((Object)"> resolved = _resolveOne_");
                            String _simpleName_3 = annotatedMethod.getSimpleName();
                            _builder.append((Object)_simpleName_3, "    ");
                            _builder.append((Object)"(source);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if (resolved.isPresent() && typeToResolve.isInstance(resolved.get())) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"return typeToResolve.cast(resolved.get());");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                        }
                        if (this.val$superResolve == null) {
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                        } else {
                            _builder.append((Object)"return super.resolveOne(source);");
                            _builder.newLine();
                        }
                    }
                };
                it.setBody(_client);
            };
            declaringClass.addMethod("resolveOne", _function_4);
            Procedures.Procedure1 _function_5 = it -> {
                TypeReference genericType = context.newTypeReference((Type)it.addTypeParameter("T", new TypeReference[0]), new TypeReference[0]);
                TypeReference resolveType = context.newTypeReference(Class.class, new TypeReference[]{genericType});
                MethodDeclaration superResolve = TypeReferenceUtil.findResolvedMethod(context.newTypeReference((Type)declaringClass, new TypeReference[0]), "resolveAll", sourceType, resolveType);
                it.setVisibility(Visibility.PROTECTED);
                it.setReturnType(context.newTypeReference(List.class, new TypeReference[]{genericType}));
                it.addParameter("source", sourceType);
                it.addParameter("typeToResolve", resolveType);
                StringConcatenationClient _client = new StringConcatenationClient((LinkedHashSet)annotatedMethodsForSourceType, superResolve){
                    private final /* synthetic */ LinkedHashSet val$annotatedMethodsForSourceType;
                    private final /* synthetic */ MethodDeclaration val$superResolve;
                    {
                        this.val$annotatedMethodsForSourceType = linkedHashSet;
                        this.val$superResolve = methodDeclaration;
                    }

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"List<T> resolved = CollectionLiterals.newLinkedList();");
                        _builder.newLine();
                        for (MutableMethodDeclaration annotatedMethod : this.val$annotatedMethodsForSourceType) {
                            _builder.append((Object)"if (typeToResolve.isAssignableFrom(");
                            String _simpleName = annotatedMethod.getReturnType().getType().getSimpleName();
                            _builder.append((Object)_simpleName);
                            _builder.append((Object)".class) || ");
                            String _simpleName_1 = annotatedMethod.getReturnType().getType().getSimpleName();
                            _builder.append((Object)_simpleName_1);
                            _builder.append((Object)".class.isAssignableFrom(typeToResolve)) {");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"final Stream<");
                            String _simpleName_2 = annotatedMethod.getReturnType().getSimpleName();
                            _builder.append((Object)_simpleName_2, "    ");
                            _builder.append((Object)"> result = _resolveAll_");
                            String _simpleName_3 = annotatedMethod.getSimpleName();
                            _builder.append((Object)_simpleName_3, "    ");
                            _builder.append((Object)"(source);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"result.filter(typeToResolve::isInstance).map(typeToResolve::cast).forEachOrdered(resolved::add);");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                        }
                        if (this.val$superResolve != null) {
                            _builder.append((Object)"resolved.addAll(super.resolveAll(source));");
                            _builder.newLine();
                        }
                        _builder.append((Object)"return resolved;");
                        _builder.newLine();
                    }
                };
                it.setBody(_client);
            };
            declaringClass.addMethod("resolveAll", _function_5);
        };
        sourceTypes.forEach(_function_3);
        BiConsumer<TypeReference, LinkedHashSet> _function_4 = (targetType, annotatedMethodsForTargetType) -> {
            Procedures.Procedure1 _function_5 = it -> {
                TypeReference genericType = context.newTypeReference((Type)it.addTypeParameter("T", new TypeReference[0]), new TypeReference[0]);
                TypeReference resolveType = context.newTypeReference(Class.class, new TypeReference[]{genericType});
                MethodDeclaration superResolve = TypeReferenceUtil.findResolvedMethod(context.newTypeReference((Type)declaringClass, new TypeReference[0]), "invResolveOne", targetType, resolveType);
                it.setReturnType(genericType);
                it.setVisibility(Visibility.PROTECTED);
                it.addParameter("target", targetType);
                it.addParameter("typeToResolve", resolveType);
                StringConcatenationClient _client = new StringConcatenationClient((LinkedHashSet)annotatedMethodsForTargetType, genericType, superResolve){
                    private final /* synthetic */ LinkedHashSet val$annotatedMethodsForTargetType;
                    private final /* synthetic */ TypeReference val$genericType;
                    private final /* synthetic */ MethodDeclaration val$superResolve;
                    {
                        this.val$annotatedMethodsForTargetType = linkedHashSet;
                        this.val$genericType = typeReference;
                        this.val$superResolve = methodDeclaration;
                    }

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        for (MutableMethodDeclaration annotatedMethod : this.val$annotatedMethodsForTargetType) {
                            _builder.append((Object)"if (");
                            Iterable _parameters = annotatedMethod.getParameters();
                            boolean _hasElements = false;
                            for (MutableParameterDeclaration param : _parameters) {
                                if (!_hasElements) {
                                    _hasElements = true;
                                } else {
                                    _builder.appendImmediate((Object)"||", "");
                                }
                                String _simpleName = param.getType().getType().getSimpleName();
                                _builder.append((Object)_simpleName);
                                _builder.append((Object)".class.isAssignableFrom(typeToResolve)");
                            }
                            _builder.append((Object)") {");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"final Optional<");
                            String _simpleName_1 = this.val$genericType.getSimpleName();
                            _builder.append((Object)_simpleName_1, "    ");
                            _builder.append((Object)"> resolved = _invResolveOne_");
                            String _simpleName_2 = annotatedMethod.getSimpleName();
                            _builder.append((Object)_simpleName_2, "    ");
                            _builder.append((Object)"(target, typeToResolve);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if (resolved.isPresent()) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"return resolved.get();");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                        }
                        if (this.val$superResolve == null) {
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                        } else {
                            _builder.append((Object)"return super.resolveOne(source);");
                            _builder.newLine();
                        }
                    }
                };
                it.setBody(_client);
            };
            declaringClass.addMethod("invResolveOne", _function_5);
            Procedures.Procedure1 _function_6 = it -> {
                TypeReference genericType = context.newTypeReference((Type)it.addTypeParameter("T", new TypeReference[0]), new TypeReference[0]);
                TypeReference resolveType = context.newTypeReference(Class.class, new TypeReference[]{genericType});
                MethodDeclaration superResolve = TypeReferenceUtil.findResolvedMethod(context.newTypeReference((Type)declaringClass, new TypeReference[0]), "invResolveAll", targetType, resolveType);
                it.setReturnType(context.newTypeReference(List.class, new TypeReference[]{genericType}));
                it.setVisibility(Visibility.PROTECTED);
                it.addParameter("target", targetType);
                it.addParameter("typeToResolve", resolveType);
                StringConcatenationClient _client = new StringConcatenationClient((LinkedHashSet)annotatedMethodsForTargetType, superResolve){
                    private final /* synthetic */ LinkedHashSet val$annotatedMethodsForTargetType;
                    private final /* synthetic */ MethodDeclaration val$superResolve;
                    {
                        this.val$annotatedMethodsForTargetType = linkedHashSet;
                        this.val$superResolve = methodDeclaration;
                    }

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"List<T> resolved = CollectionLiterals.newLinkedList();");
                        _builder.newLine();
                        for (MutableMethodDeclaration annotatedMethod : this.val$annotatedMethodsForTargetType) {
                            _builder.append((Object)"if (");
                            Iterable _parameters = annotatedMethod.getParameters();
                            boolean _hasElements = false;
                            for (MutableParameterDeclaration param : _parameters) {
                                if (!_hasElements) {
                                    _hasElements = true;
                                } else {
                                    _builder.appendImmediate((Object)"||", "");
                                }
                                String _simpleName = param.getType().getType().getSimpleName();
                                _builder.append((Object)_simpleName);
                                _builder.append((Object)".class.isAssignableFrom(typeToResolve)");
                            }
                            _builder.append((Object)") {");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"_invResolveAll_");
                            String _simpleName_1 = annotatedMethod.getSimpleName();
                            _builder.append((Object)_simpleName_1, "    ");
                            _builder.append((Object)"(target, typeToResolve).forEachOrdered(resolved::add);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"}");
                            _builder.newLine();
                        }
                        if (this.val$superResolve != null) {
                            _builder.append((Object)"resolved.addAll(super.resolveAll(source));");
                            _builder.newLine();
                        }
                        _builder.append((Object)"return resolved;");
                        _builder.newLine();
                    }
                };
                it.setBody(_client);
            };
            declaringClass.addMethod("invResolveAll", _function_6);
        };
        targetTypes.forEach(_function_4);
    }
}

