/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.graph.weighted;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.games.GameGraph;
import org.eclipse.lsat.common.ludus.backend.games.GameSubgraph;
import org.eclipse.lsat.common.ludus.backend.games.StrategyVector;
import org.eclipse.lsat.common.ludus.backend.games.VertexId;
import org.eclipse.lsat.common.ludus.backend.graph.weighted.WIntEdge;
import org.eclipse.lsat.common.ludus.backend.graph.weighted.WVertex;

public class WIntGraph
implements GameGraph<WVertex, WIntEdge>,
VertexId<WVertex>,
GameSubgraph<WVertex, WIntEdge> {
    private static final long serialVersionUID = 1L;
    private final Set<WVertex> verticesP0 = new HashSet<WVertex>();
    private final Set<WVertex> verticesP1 = new HashSet<WVertex>();
    private final Set<WVertex> vertexSet = new HashSet<WVertex>();
    private final Set<WIntEdge> edgeSet = new HashSet<WIntEdge>();

    public void addToV0(WVertex ... vertices) {
        WVertex[] wVertexArray = vertices;
        int n = vertices.length;
        int n2 = 0;
        while (n2 < n) {
            WVertex v = wVertexArray[n2];
            this.verticesP0.add(v);
            this.vertexSet.add(v);
            ++n2;
        }
    }

    public void addToV1(WVertex ... vertices) {
        WVertex[] wVertexArray = vertices;
        int n = vertices.length;
        int n2 = 0;
        while (n2 < n) {
            WVertex v = wVertexArray[n2];
            this.verticesP1.add(v);
            this.vertexSet.add(v);
            ++n2;
        }
    }

    @Override
    public Set<WIntEdge> getEdges() {
        return this.edgeSet;
    }

    public WIntEdge addEdge(WVertex source, WVertex target, Integer w1, Integer w2) {
        WIntEdge e = new WIntEdge(source, target, w1, w2);
        source.addOutgoing(e);
        target.addIncoming(e);
        this.edgeSet.add(e);
        return e;
    }

    @Override
    public Set<WVertex> getV0() {
        return this.verticesP0;
    }

    @Override
    public Set<WVertex> getV1() {
        return this.verticesP1;
    }

    @Override
    public Set<WVertex> getVertices() {
        return this.vertexSet;
    }

    @Override
    public Collection<WIntEdge> incomingEdgesOf(WVertex v) {
        return v.getIncoming();
    }

    @Override
    public Collection<WIntEdge> outgoingEdgesOf(WVertex v) {
        return v.getOutgoing();
    }

    @Override
    public WVertex getEdgeSource(WIntEdge e) {
        return e.getSource();
    }

    @Override
    public WVertex getEdgeTarget(WIntEdge e) {
        return e.getTarget();
    }

    @Override
    public WIntEdge getEdge(WVertex source, WVertex target) {
        return source.getOutgoing(target);
    }

    @Override
    public Integer getId(WVertex vertex) {
        return vertex.getId();
    }

    @Override
    public GameGraph<WVertex, WIntEdge> getSubgraph(StrategyVector<WVertex, WIntEdge> strategyVector) {
        WIntGraph subGraph = new WIntGraph();
        for (WVertex v : this.getVertices()) {
            WVertex succ = strategyVector.getSuccessor(v);
            WIntEdge edge = this.getEdge(v, succ);
            if (this.getV0().contains(v)) {
                subGraph.addToV0(v);
            } else {
                subGraph.addToV1(v);
            }
            subGraph.addEdge(v, succ, edge.getWeight1(), edge.getWeight2());
        }
        return subGraph;
    }
}

