/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.callhierarchy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.callhierarchy.CallHierarchyViewTreeNode;
import org.eclipse.lsp4e.internal.ArrayUtil;
import org.eclipse.lsp4e.internal.Pair;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.views.HierarchyViewInput;
import org.eclipse.lsp4j.CallHierarchyIncomingCall;
import org.eclipse.lsp4j.CallHierarchyIncomingCallsParams;
import org.eclipse.lsp4j.CallHierarchyItem;
import org.eclipse.lsp4j.CallHierarchyPrepareParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.ui.PlatformUI;

public class CallHierarchyContentProvider
implements ITreeContentProvider {
    private @Nullable TreeViewer treeViewer;
    private @Nullable LanguageServerWrapper languageServerWrapper;
    private @Nullable List<CallHierarchyViewTreeNode> rootItems;
    private String rootMessage = Messages.CH_finding_callers;

    public Object[] getElements(@Nullable Object inputElement) {
        if (this.rootItems != null) {
            return this.rootItems.toArray();
        }
        return new Object[]{this.rootMessage};
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof CallHierarchyViewTreeNode) {
            CallHierarchyViewTreeNode treeNode = (CallHierarchyViewTreeNode)parentElement;
            return this.findCallers(treeNode);
        }
        return ArrayUtil.NO_OBJECTS;
    }

    public @Nullable Object getParent(Object element) {
        if (element instanceof CallHierarchyViewTreeNode) {
            CallHierarchyViewTreeNode treeNode = (CallHierarchyViewTreeNode)element;
            return treeNode.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof CallHierarchyViewTreeNode;
    }

    public void inputChanged(Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.treeViewer = (TreeViewer)viewer;
        if (newInput instanceof HierarchyViewInput) {
            HierarchyViewInput viewInput = (HierarchyViewInput)newInput;
            this.rootMessage = Messages.CH_finding_callers;
            this.rootItems = null;
            IDocument document = viewInput.getDocument();
            try {
                this.initialise(document, viewInput.getOffset());
            }
            catch (Exception e) {
                this.handleRootError();
            }
        } else {
            this.handleRootError();
        }
    }

    private void initialise(IDocument document, int offset) throws BadLocationException {
        LanguageServers.LanguageServerDocumentExecutor executor = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getCallHierarchyProvider);
        if (!executor.anyMatching()) {
            this.handleRootError();
            return;
        }
        CallHierarchyPrepareParams prepareParams = LSPEclipseUtils.toCallHierarchyPrepareParams(offset, document);
        ((CompletableFuture)executor.computeFirst((w, ls) -> ls.getTextDocumentService().prepareCallHierarchy(prepareParams).thenApply(result -> new Pair<LanguageServerWrapper, List>((LanguageServerWrapper)w, (List)result))).thenAccept(o -> o.ifPresentOrElse(p -> {
            this.languageServerWrapper = (LanguageServerWrapper)p.first();
            List hierarchyItems = (List)p.second();
            if (!hierarchyItems.isEmpty()) {
                this.rootItems = new ArrayList<CallHierarchyViewTreeNode>(hierarchyItems.size());
                ArrayList<CallHierarchyViewTreeNode> rootItems = this.rootItems;
                for (CallHierarchyItem item : hierarchyItems) {
                    rootItems.add(new CallHierarchyViewTreeNode(item));
                }
            } else {
                this.rootMessage = Messages.CH_no_call_hierarchy;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                TreeViewer treeViewer = this.treeViewer;
                if (treeViewer != null) {
                    treeViewer.refresh();
                    treeViewer.expandToLevel(2);
                }
            });
        }, this::handleRootError))).handle((result, error) -> {
            if (error != null) {
                this.handleRootError();
            }
            return result;
        });
    }

    private void handleRootError() {
        this.rootItems = Collections.emptyList();
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (this.treeViewer != null) {
                this.treeViewer.refresh();
            }
        });
    }

    private Object[] findCallers(CallHierarchyViewTreeNode callee) {
        Object[] children = callee.getChildren();
        if (children == null) {
            TreeViewer treeViewer = this.treeViewer;
            if (treeViewer != null) {
                treeViewer.getControl().setEnabled(false);
            }
            this.updateCallers(callee);
            return new Object[]{Messages.CH_finding_callers};
        }
        return children;
    }

    private void updateCallers(CallHierarchyViewTreeNode callee) {
        LanguageServerWrapper languageServerWrapper = this.languageServerWrapper;
        if (languageServerWrapper == null) {
            return;
        }
        CallHierarchyIncomingCallsParams incomingCallParams = new CallHierarchyIncomingCallsParams(callee.getCallContainer());
        ((CompletableFuture)languageServerWrapper.execute(languageServer -> languageServer.getTextDocumentService().callHierarchyIncomingCalls(incomingCallParams)).thenApply(incomingCalls -> {
            if (incomingCalls == null) {
                return new ArrayList(0);
            }
            ArrayList<CallHierarchyViewTreeNode> children = new ArrayList<CallHierarchyViewTreeNode>(incomingCalls.size());
            for (CallHierarchyIncomingCall call : incomingCalls) {
                CallHierarchyItem callContainer = call.getFrom();
                List callSites = call.getFromRanges();
                for (Range callSite : callSites) {
                    CallHierarchyViewTreeNode child = new CallHierarchyViewTreeNode(callContainer, callSite);
                    child.setParent(callee);
                    children.add(child);
                }
                if (!callSites.isEmpty()) continue;
                CallHierarchyViewTreeNode child = new CallHierarchyViewTreeNode(callContainer);
                child.setParent(callee);
                children.add(child);
            }
            return children;
        })).handle((result, error) -> this.updateChildrenInView(callee, (List<CallHierarchyViewTreeNode>)result, (Throwable)error));
    }

    private @Nullable List<CallHierarchyViewTreeNode> updateChildrenInView(CallHierarchyViewTreeNode callee, @Nullable List<CallHierarchyViewTreeNode> children, @Nullable Throwable error) {
        if (error != null || children == null) {
            callee.setChildren(Collections.emptyList());
        } else {
            callee.setChildren(children);
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            TreeViewer treeViewer = this.treeViewer;
            if (treeViewer != null) {
                treeViewer.refresh();
                treeViewer.getControl().setEnabled(true);
            }
        });
        return children;
    }

    public void dispose() {
        if (this.treeViewer != null) {
            this.treeViewer.getControl().dispose();
            this.treeViewer = null;
        }
    }
}

