/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.handly.ui.search.AbstractSearchContentProvider;
import org.eclipse.handly.ui.search.AbstractSearchResultPage;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class SearchTableContentProvider
extends AbstractSearchContentProvider {
    public SearchTableContentProvider(AbstractSearchResultPage page) {
        super(page);
    }

    public Object[] getElements(Object inputElement) {
        if (!(inputElement instanceof AbstractTextSearchResult)) {
            return NO_ELEMENTS;
        }
        Object[] elements = ((AbstractTextSearchResult)inputElement).getElements();
        Integer limit = this.getPage().getElementLimit();
        ArrayList<Object> filteredElements = new ArrayList<Object>();
        int i = 0;
        while (i < elements.length && (limit == null || limit < 0 || limit > filteredElements.size())) {
            Object element = elements[i];
            if (this.getPage().getDisplayedMatchCount(element) > 0) {
                filteredElements.add(element);
            }
            ++i;
        }
        return filteredElements.toArray(NO_ELEMENTS);
    }

    @Override
    public void clear() {
        this.getPage().getViewer().refresh();
    }

    @Override
    public void elementsChanged(Object[] elements) {
        Integer limit;
        if (elements.length == 0 || this.getPage().getInput() == null) {
            return;
        }
        List<Object> added = new ArrayList<Object>();
        ArrayList<Object> removed = new ArrayList<Object>();
        ArrayList<Object> updated = new ArrayList<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (this.getPage().getDisplayedMatchCount(element) == 0) {
                removed.add(element);
            } else if (this.getPage().getViewer().testFindItem(element) == null) {
                added.add(element);
            } else {
                updated.add(element);
            }
            ++n2;
        }
        TableViewer viewer = (TableViewer)this.getPage().getViewer();
        if (!removed.isEmpty()) {
            viewer.remove(removed.toArray());
        }
        if ((limit = this.getPage().getElementLimit()) != null && limit >= 0 && !added.isEmpty()) {
            int addLimit = limit - viewer.getTable().getItemCount();
            if (addLimit <= 0) {
                added.clear();
            } else if (addLimit < added.size()) {
                added = added.subList(0, addLimit);
            }
        }
        if (!added.isEmpty()) {
            viewer.add(added.toArray());
        }
        if (!updated.isEmpty()) {
            viewer.update(updated.toArray(), null);
        }
    }
}

