/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.ITemplateSection;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.templates.ControlStack;
import org.eclipse.pde.ui.templates.IVariableProvider;
import org.eclipse.pde.ui.templates.PluginReference;

public abstract class AbstractTemplateSection
implements ITemplateSection,
IVariableProvider {
    protected IProject project;
    public static final String KEY_PLUGIN_CLASS = "pluginClass";
    public static final String KEY_ACTIVATOR_SIMPLE = "activator";
    public static final String KEY_PLUGIN_ID = "pluginId";
    public static final String KEY_PLUGIN_NAME = "pluginName";
    public static final String KEY_PACKAGE_NAME = "packageName";
    private boolean pagesAdded = false;

    @Override
    public String getReplacementString(String fileName, String key) {
        String result = this.getKeyValue(key);
        return result != null ? result : key;
    }

    public Object getValue(String key) {
        return this.getKeyValue(key);
    }

    private String getKeyValue(String key) {
        return null;
    }

    @Override
    public URL getTemplateLocation() {
        return null;
    }

    @Override
    public String getDescription() {
        return "";
    }

    public String getPluginResourceString(String key) {
        ResourceBundle bundle = this.getPluginResourceBundle();
        if (bundle == null) {
            return key;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    protected abstract ResourceBundle getPluginResourceBundle();

    @Override
    public void addPages(Wizard wizard) {
    }

    @Override
    public boolean getPagesAdded() {
        return this.pagesAdded;
    }

    protected void markPagesAdded() {
        this.pagesAdded = true;
    }

    @Override
    public int getNumberOfWorkUnits() {
        return 1;
    }

    @Override
    public IPluginReference[] getDependencies(String schemaVersion) {
        return new IPluginReference[]{new PluginReference("org.eclipse.ui", null, 0)};
    }

    protected IFolder getSourceFolder(IProgressMonitor monitor) {
        IFolder sourceFolder = null;
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry entry = classpath[i];
                if (entry.getEntryKind() == 3) {
                    IPath path = entry.getPath().removeFirstSegments(1);
                    if (path.segmentCount() > 0) {
                        sourceFolder = this.project.getFolder(path);
                    }
                    break;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            PDEPlugin.logException((Throwable)e);
        }
        return sourceFolder;
    }

    protected void generateFiles(IProgressMonitor monitor) throws CoreException {
        this.generateFiles(monitor, this.getTemplateLocation());
    }

    /*
     * Loose catch block
     */
    protected void generateFiles(IProgressMonitor monitor, URL locationUrl) throws CoreException {
        block28: {
            monitor.setTaskName(PDEUIMessages.AbstractTemplateSection_generating);
            if (locationUrl == null) {
                return;
            }
            try {
                locationUrl = FileLocator.resolve((URL)locationUrl);
                locationUrl = FileLocator.toFileURL((URL)locationUrl);
            }
            catch (IOException e) {
                return;
            }
            if ("file".equals(locationUrl.getProtocol())) {
                File templateDirectory = new File(locationUrl.getFile());
                if (!templateDirectory.exists()) {
                    return;
                }
                this.generateFiles(templateDirectory, (IContainer)this.project, true, false, monitor);
            } else if ("jar".equals(locationUrl.getProtocol())) {
                String file = locationUrl.getFile();
                int exclamation = file.indexOf(33);
                if (exclamation < 0) {
                    return;
                }
                URL fileUrl = null;
                try {
                    fileUrl = new URL(file.substring(0, exclamation));
                }
                catch (MalformedURLException mue) {
                    return;
                }
                File pluginJar = new File(fileUrl.getFile());
                if (!pluginJar.exists()) {
                    return;
                }
                String templateDirectory = file.substring(exclamation + 1);
                Path path = new Path(templateDirectory);
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(pluginJar);
                    this.generateFiles(zipFile, (IPath)path, (IContainer)this.project, true, false, monitor);
                }
                catch (ZipException zipException) {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block28;
                }
                catch (IOException iOException) {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block28;
                    catch (Throwable throwable) {
                        if (zipFile != null) {
                            try {
                                zipFile.close();
                            }
                            catch (IOException iOException3) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                if (zipFile == null) break block28;
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        monitor.subTask("");
        monitor.worked(1);
    }

    protected boolean isOkToCreateFolder(File sourceFolder) {
        return true;
    }

    protected boolean isOkToCreateFile(File sourceFile) {
        return true;
    }

    @Override
    public void execute(IProject project, IProgressMonitor monitor) throws CoreException {
        this.project = project;
        this.generateFiles(monitor);
    }

    private void generateFiles(File src, IContainer dst, boolean firstLevel, boolean binary, IProgressMonitor monitor) throws CoreException {
        File[] members = src.listFiles();
        int i = 0;
        while (i < members.length) {
            block23: {
                File member;
                block24: {
                    IFolder dstContainer;
                    block26: {
                        block25: {
                            member = members[i];
                            if (!member.isDirectory()) break block24;
                            dstContainer = null;
                            if (!firstLevel) break block25;
                            binary = false;
                            if (!this.isOkToCreateFolder(member)) break block23;
                            if (member.getName().equals("java")) {
                                IFolder sourceFolder = this.getSourceFolder(monitor);
                                dstContainer = this.generateJavaSourceFolder(sourceFolder, monitor);
                            } else if (member.getName().equals("bin")) {
                                binary = true;
                                dstContainer = dst;
                            }
                        }
                        if (dstContainer != null) break block26;
                        if (!this.isOkToCreateFolder(member)) break block23;
                        String folderName = this.getProcessedString(member.getName(), member.getName());
                        dstContainer = dst.getFolder((IPath)new Path(folderName));
                    }
                    if (dstContainer instanceof IFolder && !dstContainer.exists()) {
                        ((IFolder)dstContainer).create(true, true, monitor);
                    }
                    this.generateFiles(member, (IContainer)dstContainer, false, binary, monitor);
                    break block23;
                }
                if (this.isOkToCreateFile(member)) {
                    if (firstLevel) {
                        binary = false;
                    }
                    FileInputStream in = null;
                    try {
                        try {
                            in = new FileInputStream(member);
                            this.copyFile(member.getName(), in, dst, binary, monitor);
                        }
                        catch (IOException iOException) {
                            if (in != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (IOException iOException2) {}
                            }
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void generateFiles(ZipFile zipFile, IPath path, IContainer dst, boolean firstLevel, boolean binary, IProgressMonitor monitor) throws CoreException {
        int pathLength = path.segmentCount();
        HashMap<String, ZipEntry> childZipEntries = new HashMap<String, ZipEntry>();
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            Path entryPath = new Path(zipEntry.getName());
            if (entryPath.segmentCount() <= pathLength || !path.isPrefixOf((IPath)entryPath)) continue;
            if (entryPath.segmentCount() == pathLength + 1) {
                childZipEntries.put(zipEntry.getName(), zipEntry);
                continue;
            }
            String name = entryPath.uptoSegment(pathLength + 1).addTrailingSeparator().toString();
            if (childZipEntries.containsKey(name)) continue;
            ZipEntry dirEntry = new ZipEntry(name);
            childZipEntries.put(name, dirEntry);
        }
        for (ZipEntry zipEnry : childZipEntries.values()) {
            String name = new Path(zipEnry.getName()).lastSegment().toString();
            if (zipEnry.isDirectory()) {
                IContainer dstContainer = null;
                if (firstLevel) {
                    binary = false;
                    if (name.equals("java")) {
                        IFolder sourceFolder = this.getSourceFolder(monitor);
                        dstContainer = this.generateJavaSourceFolder(sourceFolder, monitor);
                    } else if (name.equals("bin")) {
                        binary = true;
                        dstContainer = dst;
                    }
                }
                if (dstContainer == null) {
                    if (!this.isOkToCreateFolder(new File(path.toFile(), name))) continue;
                    String folderName = this.getProcessedString(name, name);
                    dstContainer = dst.getFolder((IPath)new Path(folderName));
                }
                if (dstContainer instanceof IFolder && !dstContainer.exists()) {
                    ((IFolder)dstContainer).create(true, true, monitor);
                }
                this.generateFiles(zipFile, path.append(name), dstContainer, false, binary, monitor);
                continue;
            }
            if (!this.isOkToCreateFile(new File(path.toFile(), name))) continue;
            if (firstLevel) {
                binary = false;
            }
            InputStream in = null;
            try {
                try {
                    in = zipFile.getInputStream(zipEnry);
                    this.copyFile(name, in, dst, binary, monitor);
                }
                catch (IOException iOException) {
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException iOException2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (in == null) continue;
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private IFolder generateJavaSourceFolder(IFolder sourceFolder, IProgressMonitor monitor) throws CoreException {
        String packageName;
        Object packageValue = this.getValue(KEY_PACKAGE_NAME);
        String string = packageName = packageValue != null ? packageValue.toString() : null;
        if (packageName == null) {
            packageName = this.project.getName();
        }
        Path path = new Path(packageName.replace('.', File.separatorChar));
        if (sourceFolder != null) {
            path = sourceFolder.getProjectRelativePath().append((IPath)path);
        }
        int i = 1;
        while (i <= path.segmentCount()) {
            IPath subpath = path.uptoSegment(i);
            IFolder subfolder = this.project.getFolder(subpath);
            if (!subfolder.exists()) {
                subfolder.create(true, true, monitor);
            }
            ++i;
        }
        return this.project.getFolder((IPath)path);
    }

    private void copyFile(String fileName, InputStream input, IContainer dst, boolean binary, IProgressMonitor monitor) throws CoreException {
        String targetFileName = this.getProcessedString(fileName, fileName);
        monitor.subTask(targetFileName);
        IFile dstFile = dst.getFile((IPath)new Path(targetFileName));
        try {
            InputStream stream = this.getProcessedStream(fileName, input, binary);
            if (dstFile.exists()) {
                dstFile.setContents(stream, true, true, monitor);
            } else {
                dstFile.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getProcessedString(String fileName, String source) {
        if (source.indexOf(36) == -1) {
            return source;
        }
        int loc = -1;
        StringBuffer buffer = new StringBuffer();
        boolean replacementMode = false;
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (c == '$') {
                if (replacementMode) {
                    String key = source.substring(loc, i);
                    String value = key.length() == 0 ? "$" : this.getReplacementString(fileName, key);
                    buffer.append(value);
                    replacementMode = false;
                } else {
                    replacementMode = true;
                    loc = i + 1;
                }
            } else if (!replacementMode) {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    private InputStream getProcessedStream(String fileName, InputStream stream, boolean binary) throws IOException, CoreException {
        if (binary) {
            return stream;
        }
        InputStreamReader reader = new InputStreamReader(stream);
        int bufsize = 1024;
        char[] cbuffer = new char[bufsize];
        int read = 0;
        StringBuffer keyBuffer = new StringBuffer();
        StringBuffer outBuffer = new StringBuffer();
        StringBuffer preBuffer = new StringBuffer();
        boolean newLine = true;
        ControlStack preStack = new ControlStack();
        preStack.setValueProvider((IVariableProvider)this);
        boolean replacementMode = false;
        boolean preprocessorMode = false;
        boolean escape = false;
        while (read != -1) {
            read = reader.read(cbuffer);
            int i = 0;
            while (i < read) {
                char c = cbuffer[i];
                if (escape) {
                    StringBuffer buf = preprocessorMode ? preBuffer : outBuffer;
                    buf.append(c);
                    escape = false;
                } else if (newLine && c == '%') {
                    preprocessorMode = true;
                    preBuffer.delete(0, preBuffer.length());
                } else if (preprocessorMode) {
                    if (c == '\\') {
                        escape = true;
                    } else if (c == '\n') {
                        preprocessorMode = false;
                        newLine = true;
                        String line = preBuffer.toString().trim();
                        preStack.processLine(line);
                    } else {
                        preBuffer.append(c);
                    }
                } else if (preStack.getCurrentState()) {
                    if (c == '$') {
                        if (replacementMode) {
                            replacementMode = false;
                            String key = keyBuffer.toString();
                            String value = key.length() == 0 ? "$" : this.getReplacementString(fileName, key);
                            outBuffer.append(value);
                            keyBuffer.delete(0, keyBuffer.length());
                        } else {
                            replacementMode = true;
                        }
                    } else if (replacementMode) {
                        keyBuffer.append(c);
                    } else {
                        outBuffer.append(c);
                        newLine = c == '\n';
                    }
                }
                ++i;
            }
        }
        return new ByteArrayInputStream(outBuffer.toString().getBytes(this.project.getDefaultCharset()));
    }

    protected String getFormattedPackageName(String id) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < id.length()) {
            char ch = id.charAt(i);
            if (buffer.length() == 0) {
                if (Character.isJavaIdentifierStart(ch)) {
                    buffer.append(Character.toLowerCase(ch));
                }
            } else if (Character.isJavaIdentifierPart(ch) || ch == '.') {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString().toLowerCase(Locale.ENGLISH);
    }
}

