/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa;

import java.io.Closeable;
import java.lang.reflect.Array;
import org.eclipse.gemini.jpa.GeminiProperties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class GeminiUtil {
    public static String JPA_JDBC_DRIVER_PROPERTY = "javax.persistence.jdbc.driver";
    public static String JPA_JDBC_URL_PROPERTY = "javax.persistence.jdbc.url";
    public static String JPA_JDBC_USER_PROPERTY = "javax.persistence.jdbc.user";
    public static String JPA_JDBC_PASSWORD_PROPERTY = "javax.persistence.jdbc.password";

    public static String bundleVersion(Bundle b) {
        return b.getVersion().toString();
    }

    public static String formattedPackageString(String s, char beingReplaced, char replacer) {
        String formatted = s;
        if (formatted.indexOf(beingReplaced) >= 0) {
            formatted = formatted.replace(beingReplaced, replacer);
        }
        if (formatted.charAt(formatted.length() - 1) != replacer) {
            formatted = String.valueOf(formatted) + replacer;
        }
        return formatted;
    }

    public static void close(Closeable c) {
        try {
            c.close();
        }
        catch (Throwable throwable) {}
    }

    public static PackageAdmin getPackageAdmin(BundleContext ctx) {
        ServiceReference ref = ctx.getServiceReference(PackageAdmin.class.getName());
        return ref != null ? (PackageAdmin)ctx.getService(ref) : null;
    }

    public static String stripPrecedingSlash(String s) {
        if (s == null || s.length() == 0 || !s.startsWith("/")) {
            return s;
        }
        return s.length() == 1 ? "" : s.substring(1, s.length());
    }

    public static Class<?> loadClassFromBundle(String clsName, Bundle b) {
        GeminiUtil.debug("Loading class ", clsName, " from bundle ", b);
        try {
            return b.loadClass(clsName);
        }
        catch (ClassNotFoundException cnfEx) {
            GeminiUtil.fatalError("Could not load class " + clsName + " from bundle " + b, cnfEx);
            return null;
        }
    }

    public static void fatalError(String s, Throwable t) {
        System.out.println("*** FATAL ERROR *** " + s);
        if (t != null) {
            t.printStackTrace(System.out);
        }
        throw new RuntimeException(s, t);
    }

    public static void warning(String msg) {
        GeminiUtil.warning(msg, "");
    }

    public static void warning(String msg, Throwable t) {
        String msg2 = t != null ? " Exception: " + t : "";
        GeminiUtil.warning(msg, msg2);
    }

    public static void warning(String msg, String msg2) {
        String outputMsg = "WARNING: " + msg + msg2;
        System.out.println(outputMsg);
    }

    public static void debugXml(String ... msgs) {
        if (GeminiProperties.debugXml()) {
            GeminiUtil.privateDebug(msgs);
        }
    }

    public static void debugClassLoader(String ... msgs) {
        if (GeminiProperties.debugClassloader()) {
            GeminiUtil.privateDebug(msgs);
        }
    }

    public static void debugClassLoader(String s, ClassLoader cl) {
        if (GeminiProperties.debugClassloader()) {
            System.out.println(String.valueOf(s) + String.valueOf(cl));
            ClassLoader p = cl;
            while (p.getParent() != null) {
                System.out.println("  Parent loader: " + p.getParent());
                p = p.getParent();
            }
        }
    }

    public static void debugWeaving(String ... msgs) {
        if (GeminiProperties.debugWeaving()) {
            GeminiUtil.privateDebug(msgs);
        }
    }

    public static void debug(String ... msgs) {
        if (GeminiProperties.debug()) {
            GeminiUtil.privateDebug(msgs);
        }
    }

    public static void debug(Object ... args) {
        if (GeminiProperties.debug()) {
            GeminiUtil.privateDebug(args);
        }
    }

    public static void debug(String msg, Object obj) {
        if (GeminiProperties.debug()) {
            if (obj == null) {
                System.out.println(String.valueOf(msg) + String.valueOf(obj));
            } else if (ClassLoader.class.isAssignableFrom(obj.getClass()) && GeminiProperties.debugXml()) {
                GeminiUtil.debugClassLoader(msg, (ClassLoader)obj);
            } else if (Bundle.class.isAssignableFrom(obj.getClass())) {
                Bundle b = (Bundle)obj;
                System.out.println(String.valueOf(msg) + " bundle=" + b.getSymbolicName() + " id=" + b.getBundleId() + " state=" + GeminiUtil.stringBundleStateFromInt(b.getState()));
            } else if (BundleEvent.class.isAssignableFrom(obj.getClass())) {
                BundleEvent event = (BundleEvent)obj;
                System.out.println(String.valueOf(msg) + " bundle=" + event.getBundle().getSymbolicName() + ", event=" + GeminiUtil.stringBundleEventFromInt(event.getType()));
            } else if (obj.getClass().isArray()) {
                System.out.println(msg);
                int len = ((Object[])obj).length;
                int i = 0;
                while (i < len) {
                    System.out.print("  ");
                    System.out.println(String.valueOf(Array.get(obj, i)));
                    ++i;
                }
            } else {
                System.out.println(String.valueOf(msg) + String.valueOf(obj));
            }
        }
    }

    public static String stringBundleStateFromInt(int bundleState) {
        switch (bundleState) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return "UNDEFINED_STATE";
    }

    public static String stringBundleEventFromInt(int eventType) {
        switch (eventType) {
            case 1: {
                return "INSTALLED";
            }
            case 2: {
                return "STARTED";
            }
            case 4: {
                return "STOPPED";
            }
            case 8: {
                return "UPDATED";
            }
            case 16: {
                return "UNINSTALLED";
            }
            case 32: {
                return "RESOLVED";
            }
            case 64: {
                return "UNRESOLVED";
            }
            case 128: {
                return "STARTING";
            }
            case 256: {
                return "STOPPING";
            }
            case 512: {
                return "LAZY_ACTIVATION";
            }
        }
        return "UNDEFINED_EVENT";
    }

    public static void privateDebug(String ... msgs) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = msgs;
        int n = msgs.length;
        int n2 = 0;
        while (n2 < n) {
            String msg = stringArray[n2];
            sb.append(msg);
            ++n2;
        }
        System.out.println(sb.toString());
    }

    public static void privateDebug(Object ... args) {
        String[] msgs = new String[args.length];
        int i = 0;
        while (i < args.length) {
            msgs[i] = String.valueOf(args[i]);
            ++i;
        }
        GeminiUtil.privateDebug(msgs);
    }
}

