/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.escet.cif.simulator.input.ChosenTargetTime;
import org.eclipse.escet.cif.simulator.options.InputMode;
import org.eclipse.escet.cif.simulator.options.InputModeOption;
import org.eclipse.escet.cif.simulator.options.InteractiveAutoChooseOption;
import org.eclipse.escet.cif.simulator.options.ProfilingOption;
import org.eclipse.escet.cif.simulator.output.NormalOutputOption;
import org.eclipse.escet.cif.simulator.output.NormalOutputStateFiltersOption;
import org.eclipse.escet.cif.simulator.output.NormalOutputType;
import org.eclipse.escet.cif.simulator.output.SimulatorOutputComponent;
import org.eclipse.escet.cif.simulator.runtime.SimulationResult;
import org.eclipse.escet.cif.simulator.runtime.meta.RuntimeStateFilterer;
import org.eclipse.escet.cif.simulator.runtime.meta.RuntimeStateObjectMeta;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.transitions.TimeTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.output.StreamOutputComponent;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public final class SimulatorStreamOutputComponent
extends StreamOutputComponent
implements SimulatorOutputComponent {
    private boolean profiling;
    private EnumSet<NormalOutputType> outTypes;
    private boolean printStateAlg;
    private boolean printStateDerivs;
    private boolean printSingle;
    private boolean printMulti;
    private List<RuntimeStateObjectMeta> metas;
    private long lastTime;
    private int count;

    public SimulatorStreamOutputComponent(AppStream out, AppStream warn, AppStream err) {
        super(out, warn, err);
    }

    private void initializeOptions(RuntimeState state) {
        if (this.outTypes != null) {
            return;
        }
        this.profiling = ProfilingOption.isEnabled();
        if (this.profiling) {
            this.lastTime = System.nanoTime();
        }
        this.outTypes = NormalOutputOption.getOutputTypes();
        this.printStateAlg = this.outTypes.contains((Object)NormalOutputType.STATE_ALG_VARS);
        this.printStateDerivs = this.outTypes.contains((Object)NormalOutputType.STATE_DERIVS);
        if (this.outTypes.contains((Object)NormalOutputType.TRANS_ALWAYS)) {
            this.printSingle = true;
            this.printMulti = true;
        } else if (this.outTypes.contains((Object)NormalOutputType.TRANS_DEFAULT)) {
            imode = InputModeOption.getInputMode();
            boolean single = InteractiveAutoChooseOption.autoChooseSingle(InteractiveAutoChooseOption.getFilters());
            this.printSingle = imode == InputMode.CONSOLE && !single;
            this.printMulti = true;
        } else if (this.outTypes.contains((Object)NormalOutputType.TRANS_MINIMAL)) {
            imode = InputModeOption.getInputMode();
            boolean single = InteractiveAutoChooseOption.autoChooseSingle(InteractiveAutoChooseOption.getFilters());
            this.printSingle = imode == InputMode.CONSOLE && !single;
            this.printMulti = imode == InputMode.CONSOLE;
        } else {
            this.printSingle = false;
            this.printMulti = false;
        }
        if (state != null) {
            String filtersTxt = NormalOutputStateFiltersOption.getFilters();
            this.metas = state.spec.stateObjectsMeta;
            this.metas = RuntimeStateFilterer.filter(this.metas, filtersTxt, "Normal console output", "printed to the console as part of states.");
        }
    }

    @Override
    public void initialState(RuntimeState state) {
        this.initializeOptions(state);
        if (this.outTypes.contains((Object)NormalOutputType.STATE_INIT)) {
            this.out.println("Initial state: " + state.toSingleLineString(this.metas, this.printStateAlg, this.printStateDerivs));
            this.out.println();
        }
    }

    @Override
    public void possibleTransitions(List<Transition<?>> transitions, SimulationResult result) {
        if (transitions.isEmpty()) {
            return;
        }
        if (!this.printSingle && !this.printMulti) {
            return;
        }
        int count = transitions.size();
        if (count == 1 && this.printSingle || count > 1 && this.printMulti) {
            this.out.println("Possible transitions:");
            int maxNrLength = String.valueOf(transitions.size() - 1).length();
            int i = 0;
            while (i < transitions.size()) {
                Transition<?> transition = transitions.get(i);
                this.out.println(Strings.fmt((String)("  #%" + maxNrLength + "d: %s"), (Object[])new Object[]{i + 1, transition}));
                ++i;
            }
            this.out.println();
        }
    }

    @Override
    public void transitionChosen(RuntimeState sourceState, Transition<?> transition, ChosenTargetTime chosenTargetTime) {
        if (this.outTypes.contains((Object)NormalOutputType.CHOSEN_TRANS)) {
            String txt;
            if (transition instanceof TimeTransition) {
                Assert.check((boolean)(transition instanceof TimeTransition));
                double sourceTime = sourceState.getTime();
                double delay = chosenTargetTime.getDelay();
                txt = Strings.fmt((String)"delaying for %s time units at time %s", (Object[])new Object[]{delay, sourceTime});
            } else {
                txt = transition.toString();
            }
            this.out.println("Transition: " + txt);
        }
    }

    @Override
    public void intermediateTrajectoryState(RuntimeState state) {
        if (this.outTypes.contains((Object)NormalOutputType.STATE_INTERMEDIATE)) {
            this.out.println("Frame: " + state.toSingleLineString(this.metas, this.printStateAlg, this.printStateDerivs));
        }
    }

    @Override
    public void transitionTaken(RuntimeState sourceState, Transition<?> transition, RuntimeState targetState, Boolean interrupted) {
        if (this.outTypes.contains((Object)NormalOutputType.INTERRUPTED_TRANS) && interrupted != null && interrupted.booleanValue()) {
            double delay = targetState.getTime() - sourceState.getTime();
            this.out.println(Strings.fmt((String)"Time transition interrupted after %s time units.", (Object[])new Object[]{delay}));
        }
        if (this.outTypes.contains((Object)NormalOutputType.STATE_TARGET)) {
            this.out.println("State: " + targetState.toSingleLineString(this.metas, this.printStateAlg, this.printStateDerivs));
            this.out.println();
        }
        if (this.profiling) {
            ++this.count;
            long nanoSecs = System.nanoTime() - this.lastTime;
            if ((double)nanoSecs >= 1.0E9) {
                double transPerSec = (double)this.count / ((double)nanoSecs / 1.0E9);
                this.out.println(Strings.fmt((String)"%.2f transitions/second", (Object[])new Object[]{transPerSec}));
                this.lastTime = System.nanoTime();
                this.count = 0;
            }
        }
    }

    @Override
    public void simulationEnded(SimulationResult rslt, RuntimeState state) {
        this.initializeOptions(state);
        if (state != null && (this.outTypes.contains((Object)NormalOutputType.STATE_FINAL) || rslt == SimulationResult.DEADLOCK && this.outTypes.contains((Object)NormalOutputType.STATE_DEADLOCK))) {
            this.out.println(Strings.fmt((String)"%s state: %s", (Object[])new Object[]{rslt == SimulationResult.DEADLOCK ? "Deadlock" : "Final", state.toSingleLineString(this.metas, this.printStateAlg, this.printStateDerivs)}));
        }
        if (this.outTypes.contains((Object)NormalOutputType.SIM_RSLT)) {
            switch (rslt) {
                case INIT_FAILED: {
                    this.out.println("Simulation ended due to initialization failure.");
                    break;
                }
                case DEADLOCK: {
                    this.out.println("Simulation resulted in deadlock.");
                    break;
                }
                case ENDTIME_REACHED: {
                    this.out.println("Simulation ended due to reaching the user-provided simulation end time.");
                    break;
                }
                case USER_TERMINATED: {
                    this.out.println("Simulation was terminated per the user's request.");
                }
            }
        }
    }

    @Override
    public boolean hasVisualInterface() {
        return false;
    }

    @Override
    public boolean supportsRealTimeSimulation() {
        return false;
    }
}

