/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class RangeIterator
implements Iterator<Integer> {
    private int current;
    private final int step;
    private final int end;

    public RangeIterator(int start, int end, int step) {
        this.current = start;
        this.end = end;
        this.step = step == 0 ? 1 : step;
    }

    @Override
    public boolean hasNext() {
        if (this.step > 0) {
            return this.current < this.end;
        }
        return this.current > this.end;
    }

    @Override
    public Integer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int result = this.current;
        this.current += this.step;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

