/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ui.ESCompare;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;

public class HistoryCompare {
    private static final String HISTORY_COMPARE_ID = "org.eclipse.emf.emfstore.client.ui.historyBrowserComparator";

    public static boolean hasRegisteredExtensions() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(HISTORY_COMPARE_ID);
        return config.length != 0;
    }

    public static void handleRegisteredExtensions(final EObject e1, final EObject e2) {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(HISTORY_COMPARE_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                final Object o = e.createExecutableExtension("comparator");
                if (o instanceof ESCompare) {
                    ISafeRunnable runnable = new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            ModelUtil.logException((Throwable)exception);
                        }

                        public void run() throws Exception {
                            ESCompare extension = (ESCompare)o;
                            extension.compare(e1, e2);
                            extension.display();
                        }
                    };
                    SafeRunner.run((ISafeRunnable)runnable);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            ModelUtil.logWarning((String)"Error while instantiating compare provider!", (Throwable)ex);
        }
    }
}

