/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.intermediate;

import java.util.ArrayList;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class RootProcessor
implements ILayoutProcessor<TGraph> {
    private ArrayList<TNode> roots = new ArrayList();

    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Find roots", 1.0f);
        this.roots.clear();
        for (TNode node : tGraph.getNodes()) {
            if (!node.getIncomingEdges().isEmpty()) continue;
            node.setProperty(InternalProperties.ROOT, true);
            this.roots.add(node);
        }
        switch (this.roots.size()) {
            case 0: {
                assert (tGraph.getNodes().isEmpty());
                TNode root = new TNode(0, tGraph, "DUMMY_ROOT");
                root.setProperty(InternalProperties.ROOT, true);
                root.setProperty(InternalProperties.DUMMY, true);
                tGraph.getNodes().add(root);
                break;
            }
            case 1: {
                break;
            }
            default: {
                TNode superRoot = new TNode(0, tGraph, "SUPER_ROOT");
                for (TNode tRoot : this.roots) {
                    superRoot.addChild(tRoot);
                    tRoot.setProperty(InternalProperties.ROOT, false);
                }
                superRoot.setProperty(InternalProperties.ROOT, true);
                superRoot.setProperty(InternalProperties.DUMMY, true);
                tGraph.getNodes().add(superRoot);
            }
        }
        progressMonitor.done();
    }
}

