/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.provider;

import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.ui.table.HistoryFileFilter;
import org.eclipse.egerrit.internal.ui.table.HistoryResetFilter;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class DynamicHistoryMenuBuilder {
    private Menu commonMenu;
    protected static HistoryFileFilter humanOnlyfilter;
    protected static HistoryFileFilter machineOnlyfilter;

    public void addPulldownMenu(final ColumnViewer viewer, final GerritClient client) {
        MenuManager menuManager = new MenuManager();
        if (viewer instanceof TableViewer) {
            this.commonMenu = menuManager.createContextMenu((Control)((TableViewer)viewer).getTable());
            ((TableViewer)viewer).getTable().setMenu(this.commonMenu);
        }
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DynamicHistoryMenuBuilder.this.addMenuItem(DynamicHistoryMenuBuilder.this.commonMenu, viewer, client);
            }
        });
        menuManager.update(true);
    }

    private void addMenuItem(Menu menu, ColumnViewer viewer, GerritClient client) {
        if (menu.getItemCount() == 0 && viewer instanceof TableViewer) {
            MenuItem humanOnly = new MenuItem(menu, 32);
            MenuItem machineOnly = new MenuItem(menu, 32);
            new MenuItem(menu, 2);
            MenuItem reset = new MenuItem(menu, 32);
            this.setMenu(humanOnly, viewer, Messages.UIHistoryTable_0, new HistoryFileFilter(false));
            this.setMenu(machineOnly, viewer, Messages.UIHistoryTable_1, new HistoryFileFilter(true));
            this.setMenu(reset, viewer, Messages.UIHistoryTable_reset, new HistoryResetFilter());
        }
    }

    private void setMenu(final MenuItem menuItem, final ColumnViewer viewer, String name, final ViewerFilter filter) {
        menuItem.setText(name);
        menuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (menuItem.getSelection()) {
                    if (filter instanceof HistoryResetFilter) {
                        ViewerFilter[] filters;
                        MenuItem[] items;
                        viewer.addFilter(filter);
                        Menu parent = menuItem.getParent();
                        MenuItem[] menuItemArray = items = parent.getItems();
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MenuItem mi = menuItemArray[n2];
                            mi.setSelection(false);
                            ++n2;
                        }
                        ViewerFilter[] viewerFilterArray = filters = viewer.getFilters();
                        int n3 = filters.length;
                        n = 0;
                        while (n < n3) {
                            ViewerFilter filter2 = viewerFilterArray[n];
                            viewer.removeFilter(filter2);
                            ++n;
                        }
                        viewer.refresh();
                    } else {
                        viewer.addFilter(filter);
                    }
                } else {
                    viewer.removeFilter(filter);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }
}

