/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.wildfly;

import jakarta.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.internal.helper.JPAClassLoaderHolder;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.platform.server.JMXEnabledPlatform;
import org.eclipse.persistence.platform.server.JMXServerPlatformBase;
import org.eclipse.persistence.services.wildfly.MBeanWildFlyRuntimeServices;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.transaction.wildfly.WildFlyTransactionController;
import org.eclipse.persistence.transaction.wildfly.WildFlyTransactionController11;

public class WildFlyPlatform
extends JMXServerPlatformBase
implements JMXEnabledPlatform {
    public WildFlyPlatform(DatabaseSession newDatabaseSession) {
        super(newDatabaseSession);
        this.enableRuntimeServices();
        this.prepareServerSpecificServicesMBean();
    }

    @Override
    public boolean isRuntimeServicesEnabledDefault() {
        return true;
    }

    @Override
    public Class<? extends ExternalTransactionController> getExternalTransactionControllerClass() {
        if (this.externalTransactionControllerClass == null) {
            this.externalTransactionControllerClass = this.isJTA11() ? WildFlyTransactionController11.class : WildFlyTransactionController.class;
        }
        return this.externalTransactionControllerClass;
    }

    @Override
    public JPAClassLoaderHolder getNewTempClassLoader(PersistenceUnitInfo puInfo) {
        ClassLoader realClassLoader = puInfo.getClassLoader();
        AbstractSessionLog.getLog().log(6, "persistence_unit_processor_wildfly_temp_classloader_bypassed", puInfo.getPersistenceUnitName(), (Object)realClassLoader);
        return new JPAClassLoaderHolder(realClassLoader, false);
    }

    @Override
    public void prepareServerSpecificServicesMBean() {
        if (this.getDatabaseSession() != null && this.shouldRegisterRuntimeBean) {
            this.setRuntimeServicesMBean(new MBeanWildFlyRuntimeServices(this.getDatabaseSession()));
        }
    }

    @Override
    public void serverSpecificRegisterMBean() {
        super.serverSpecificRegisterMBean();
        this.initializeApplicationNameAndModuleName();
    }

    static {
        APP_SERVER_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_PREFIX = "/deploy/";
        APP_SERVER_CLASSLOADER_MODULE_EJB_SEARCH_STRING_PREFIX = ".jar/";
        APP_SERVER_CLASSLOADER_MODULE_WAR_SEARCH_STRING_PREFIX = ".war/";
        APP_SERVER_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_POSTFIX = "/}";
        APP_SERVER_CLASSLOADER_MODULE_EJB_WAR_SEARCH_STRING_POSTFIX = "postfix,match~not;required^";
    }
}

