/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.oa.poa.Policies;
import com.sun.corba.ee.impl.transport.InboundConnectionCacheImpl;
import com.sun.corba.ee.impl.transport.MessageTraceManagerImpl;
import com.sun.corba.ee.impl.transport.OutboundConnectionCacheImpl;
import com.sun.corba.ee.impl.transport.SelectorImpl;
import com.sun.corba.ee.spi.ior.IORTemplate;
import com.sun.corba.ee.spi.ior.ObjectAdapterId;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.Acceptor;
import com.sun.corba.ee.spi.transport.ByteBufferPool;
import com.sun.corba.ee.spi.transport.ContactInfo;
import com.sun.corba.ee.spi.transport.InboundConnectionCache;
import com.sun.corba.ee.spi.transport.MessageTraceManager;
import com.sun.corba.ee.spi.transport.OutboundConnectionCache;
import com.sun.corba.ee.spi.transport.Selector;
import com.sun.corba.ee.spi.transport.TransportManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;

@Transport
public class TransportManagerImpl
implements TransportManager {
    protected ORB orb;
    protected List<Acceptor> acceptors;
    protected final Map<String, OutboundConnectionCache> outboundConnectionCaches;
    protected final Map<String, InboundConnectionCache> inboundConnectionCaches;
    protected Selector selector;
    private ThreadLocal currentMessageTraceManager = new ThreadLocal(){

        public Object initialValue() {
            return new MessageTraceManagerImpl();
        }
    };

    public TransportManagerImpl(ORB orb) {
        this.orb = orb;
        this.acceptors = new ArrayList<Acceptor>();
        this.outboundConnectionCaches = new HashMap<String, OutboundConnectionCache>();
        this.inboundConnectionCaches = new HashMap<String, InboundConnectionCache>();
        this.selector = new SelectorImpl(orb);
        if (orb.mom() != null) {
            orb.mom().register((Object)orb, (Object)this);
        }
    }

    @Override
    public ByteBufferPool getByteBufferPool(int id) {
        throw new RuntimeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutboundConnectionCache getOutboundConnectionCache(ContactInfo contactInfo) {
        ContactInfo contactInfo2 = contactInfo;
        synchronized (contactInfo2) {
            if (contactInfo.getConnectionCache() == null) {
                OutboundConnectionCache connectionCache = null;
                Map<String, OutboundConnectionCache> map = this.outboundConnectionCaches;
                synchronized (map) {
                    connectionCache = this.outboundConnectionCaches.get(contactInfo.getConnectionCacheType());
                    if (connectionCache == null) {
                        connectionCache = new OutboundConnectionCacheImpl(this.orb, contactInfo);
                        if (this.orb.mom() != null) {
                            this.orb.mom().register((Object)this, (Object)connectionCache);
                        }
                        StatsProviderManager.register((String)"orb", (PluginPoint)PluginPoint.SERVER, (String)"orb/transport/connectioncache/outbound", (Object)connectionCache);
                        this.outboundConnectionCaches.put(contactInfo.getConnectionCacheType(), connectionCache);
                    }
                }
                contactInfo.setConnectionCache(connectionCache);
            }
            return contactInfo.getConnectionCache();
        }
    }

    @Override
    public Collection<OutboundConnectionCache> getOutboundConnectionCaches() {
        return this.outboundConnectionCaches.values();
    }

    @Override
    public Collection<InboundConnectionCache> getInboundConnectionCaches() {
        return this.inboundConnectionCaches.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InboundConnectionCache getInboundConnectionCache(Acceptor acceptor) {
        Acceptor acceptor2 = acceptor;
        synchronized (acceptor2) {
            if (acceptor.getConnectionCache() == null) {
                InboundConnectionCache connectionCache = null;
                Map<String, InboundConnectionCache> map = this.inboundConnectionCaches;
                synchronized (map) {
                    connectionCache = this.inboundConnectionCaches.get(acceptor.getConnectionCacheType());
                    if (connectionCache == null) {
                        connectionCache = new InboundConnectionCacheImpl(this.orb, acceptor);
                        if (this.orb.mom() != null) {
                            this.orb.mom().register((Object)this, (Object)connectionCache);
                        }
                        StatsProviderManager.register((String)"orb", (PluginPoint)PluginPoint.SERVER, (String)"orb/transport/connectioncache/inbound", (Object)connectionCache);
                        this.inboundConnectionCaches.put(acceptor.getConnectionCacheType(), connectionCache);
                    }
                }
                acceptor.setConnectionCache(connectionCache);
            }
            return acceptor.getConnectionCache();
        }
    }

    @Override
    public Selector getSelector() {
        return this.selector;
    }

    @Override
    public Selector getSelector(int id) {
        return this.selector;
    }

    @Override
    @Transport
    public synchronized void registerAcceptor(Acceptor acceptor) {
        this.acceptors.add(acceptor);
    }

    @Override
    @Transport
    public synchronized void unregisterAcceptor(Acceptor acceptor) {
        this.acceptors.remove(acceptor);
    }

    @Override
    @Transport
    public void close() {
        for (OutboundConnectionCache outboundConnectionCache : this.outboundConnectionCaches.values()) {
            StatsProviderManager.unregister((Object)outboundConnectionCache);
            outboundConnectionCache.close();
        }
        for (InboundConnectionCache inboundConnectionCache : this.inboundConnectionCaches.values()) {
            StatsProviderManager.unregister((Object)inboundConnectionCache);
            inboundConnectionCache.close();
        }
        this.getSelector(0).close();
    }

    @Override
    public Collection<Acceptor> getAcceptors() {
        return this.getAcceptors(null, null);
    }

    @InfoMethod
    private void display(String msg) {
    }

    @Override
    @Transport
    public Collection<Acceptor> getAcceptors(String objectAdapterManagerId, ObjectAdapterId objectAdapterId) {
        for (Acceptor acc : this.acceptors) {
            if (!acc.initialize()) continue;
            this.display("initializing acceptors");
            if (!acc.shouldRegisterAcceptEvent()) continue;
            this.orb.getTransportManager().getSelector(0).registerForEvent(acc.getEventHandler());
        }
        return this.acceptors;
    }

    @Override
    @Transport
    public void addToIORTemplate(IORTemplate iorTemplate, Policies policies, String codebase, String objectAdapterManagerId, ObjectAdapterId objectAdapterId) {
        for (Acceptor acceptor : this.getAcceptors(objectAdapterManagerId, objectAdapterId)) {
            acceptor.addToIORTemplate(iorTemplate, policies, codebase);
        }
    }

    @Override
    public MessageTraceManager getMessageTraceManager() {
        return (MessageTraceManager)this.currentMessageTraceManager.get();
    }
}

