/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config.types;

import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.LinkedList;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.config.HK2DomConfigUtilities;

public class HK2DomConfigTypesUtilities {
    private static final String PROPERTY_GENERATED_INJECTOR_CLASS = "org.jvnet.hk2.config.types.PropertyInjector";
    private static final String CONFIG_INJECTOR_CLASS = "org.jvnet.hk2.config.ConfigInjector";
    private static final String NAME = "property";
    private static final String INJECTION_TARGET_QUALIFIER = "org.jvnet.hk2.config.InjectionTarget";
    private static final String REQUIRED = "required";
    private static final String OPTIONAL = "optional";
    private static final String STRING_DATATYPE = "datatype:java.lang.String";
    private static final String LEAF = "leaf";
    private static final String PROPERTY_CLASS = "org.jvnet.hk2.config.types.Property";
    private static final String NAME_FIELD = "@name";
    private static final String VALUE_FIELD = "@value";
    private static final String DESCRIPTION_FIELD = "@description";
    private static final String KEYED_AS = "keyed-as";
    private static final String TARGET = "target";
    private static final String KEY = "key";

    public static void enableHK2DomConfigurationConfigTypes(ServiceLocator locator) {
        HK2DomConfigTypesUtilities.enableHK2DomConfigurationConfigTypes(locator, null);
    }

    public static void enableHK2DomConfigurationConfigTypes(ServiceLocator locator, HK2Loader loader) {
        if (locator.getBestDescriptor((Filter)BuilderHelper.createContractFilter((String)PROPERTY_GENERATED_INJECTOR_CLASS)) != null) {
            return;
        }
        HK2DomConfigUtilities.enableHK2DomConfiguration((ServiceLocator)locator, (HK2Loader)loader);
        LinkedList<String> namedList = new LinkedList<String>();
        namedList.add(REQUIRED);
        namedList.add(STRING_DATATYPE);
        namedList.add(LEAF);
        LinkedList<String> valueList = new LinkedList<String>();
        valueList.add(REQUIRED);
        valueList.add(STRING_DATATYPE);
        valueList.add(LEAF);
        LinkedList<String> keyedAsList = new LinkedList<String>();
        keyedAsList.add(PROPERTY_CLASS);
        LinkedList<String> targetList = new LinkedList<String>();
        targetList.add(PROPERTY_CLASS);
        LinkedList<String> descriptionList = new LinkedList<String>();
        descriptionList.add(OPTIONAL);
        descriptionList.add(STRING_DATATYPE);
        descriptionList.add(LEAF);
        DescriptorImpl injectorDescriptor = BuilderHelper.link((String)PROPERTY_GENERATED_INJECTOR_CLASS).to(CONFIG_INJECTOR_CLASS).in(Singleton.class.getName()).named(NAME).qualifiedBy(INJECTION_TARGET_QUALIFIER).has(NAME_FIELD, namedList).has(VALUE_FIELD, valueList).has(KEYED_AS, keyedAsList).has(TARGET, targetList).has(DESCRIPTION_FIELD, descriptionList).has(KEY, NAME_FIELD).build();
        injectorDescriptor.removeQualifier(Named.class.getName());
        if (loader != null) {
            injectorDescriptor.setLoader(loader);
        }
        ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)locator, (Descriptor)injectorDescriptor);
    }
}

