/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.spi.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.ide.spi.util.EcoreHelper;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;

public final class ViewModelHelper {
    private ViewModelHelper() {
    }

    public static VView createViewModel(IFile modelFile, EClass selectedEClass, IFile selectedEcore) throws IOException {
        EPackage ep;
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{adapterFactory, new ReflectiveItemProviderAdapterFactory()});
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new BasicCommandStack());
        URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
        Resource resource = domain.createResource(fileURI.toString());
        VView view = VViewPackage.eINSTANCE.getViewFactory().createView();
        if (view == null) {
            return null;
        }
        resource.getContents().add((Object)view);
        EPackage ePackage = selectedEClass.getEPackage();
        EPackage.Registry instance = EPackage.Registry.INSTANCE;
        Object ePackageObject = instance.get((Object)ePackage.getNsURI());
        if (EPackage.Descriptor.class.isInstance(ePackageObject)) {
            EPackage.Descriptor descriptor = (EPackage.Descriptor)EPackage.Descriptor.class.cast(ePackageObject);
            ep = descriptor.getEPackage();
        } else {
            ep = EPackage.class.isInstance(ePackageObject) ? (EPackage)ePackageObject : null;
        }
        if (ep == null && selectedEcore != null) {
            EcoreHelper.registerEcore(selectedEcore.getFullPath().toString());
            ep = (EPackage)instance.get((Object)ePackage.getNsURI());
        }
        EClass ec = (EClass)ep.getEClassifier(selectedEClass.getName());
        view.setRootEClass(ec);
        view.setName(selectedEClass.getName());
        if (selectedEcore != null) {
            view.setEcorePath(selectedEcore.getFullPath().toString());
        }
        HashMap options = new HashMap();
        resource.save(options);
        return view;
    }

    public static VView loadView(IFile file, Collection<String> registeredEcores) throws IOException {
        String path = file.getLocation().toString();
        VView view = ViewModelHelper.loadView(path);
        if (view != null && !ViewModelHelper.viewIsResolved(view)) {
            return ViewModelHelper.tryResolve(view, path, registeredEcores);
        }
        return view;
    }

    private static VView tryResolve(VView view, String path, Collection<String> registeredEcores) throws IOException {
        EcoreUtil.resolveAll((EObject)view);
        if (ViewModelHelper.viewIsResolved(view)) {
            return view;
        }
        if (view.getEcorePath() == null || ResourcesPlugin.getWorkspace().getRoot().findMember(view.getEcorePath()) == null) {
            throw new FileNotFoundException(path);
        }
        EcoreHelper.registerEcore(view.getEcorePath());
        registeredEcores.add(view.getEcorePath());
        VView reloadView = ViewModelHelper.loadView(path);
        if (reloadView != null && !ViewModelHelper.viewIsResolved(reloadView)) {
            EcoreUtil.resolveAll((EObject)reloadView);
        }
        return reloadView;
    }

    public static boolean viewIsResolved(VView view) {
        return !view.getRootEClass().eIsProxy();
    }

    private static VView loadView(String path) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createFileURI((String)path);
        Resource resource = resourceSet.getResource(fileURI, true);
        if (resource != null) {
            return (VView)resource.getContents().get(0);
        }
        return null;
    }
}

