/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.modeling;

import com.google.common.collect.Lists;
import java.util.Iterator;
import org.eclipse.core.expressions.IIterable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.modules.modeling.SelectorService;
import org.eclipse.ease.modules.platform.UIModule;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;

public class SelectionModule
extends AbstractScriptModule {
    @WrapToScript
    public Object getCustomSelection() {
        this.getEnvironment().getModule(UIModule.class);
        ISelection selection = UIModule.getSelection(null);
        IEvaluationService esrvc = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        Object customSelection = SelectorService.getInstance().getSelectionFromContext(selection, esrvc.getCurrentState());
        if (customSelection != null) {
            return customSelection;
        }
        return selection;
    }

    @WrapToScript
    public Object getCustomSelectionFromSelector(String selectorID) {
        this.getEnvironment().getModule(UIModule.class);
        ISelection selection = UIModule.getSelection(null);
        return SelectorService.getInstance().getSelectionFromSelector(selection, selectorID);
    }

    @WrapToScript
    public Iterable<Object> getIterableSelection(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String name) {
        ISelection selection = UIModule.getSelection((String)name);
        IIterable result = this.getAdapter(IIterable.class, selection);
        if (result != null) {
            return Lists.newArrayList((Iterator)result.iterator());
        }
        ((UIModule)this.getEnvironment().getModule(UIModule.class)).showErrorDialog("Error", "The current selection is not an iterable");
        return null;
    }

    protected <T> T getAdapter(Class<T> cla, Object o) {
        if (o != null && cla != null) {
            if (cla.isInstance(o)) {
                return (T)o;
            }
            if (o instanceof IAdaptable) {
                return (T)((IAdaptable)o).getAdapter(cla);
            }
            IAdapterManager manager = Platform.getAdapterManager();
            if (manager != null) {
                return (T)manager.getAdapter(o, cla);
            }
            Logger.error((String)"org.eclipse.ease.modules.modeling", (String)"Unable to get thr AdapterManger");
            return null;
        }
        return null;
    }
}

