/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.ui.editor;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.lang.unittest.UnitTestHelper;
import org.eclipse.ease.lang.unittest.definition.IDefinitionPackage;
import org.eclipse.ease.lang.unittest.runtime.ITestContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestEntity;
import org.eclipse.ease.lang.unittest.runtime.ITestFile;
import org.eclipse.ease.lang.unittest.runtime.ITestFolder;
import org.eclipse.ease.lang.unittest.ui.Activator;
import org.eclipse.ease.lang.unittest.ui.editor.AbstractEditorPage;
import org.eclipse.ease.lang.unittest.ui.views.TestSuiteLabelProvider;
import org.eclipse.ease.lang.unittest.ui.views.UnitTestView;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class FileSelectionPage
extends AbstractEditorPage {
    private ContainerCheckedTreeViewer fTestFilesTreeViewer;
    private Text fTxtIncludeFilters;
    private Text fTxtExcludeFilters;
    private Map<Object, String> fFilteredFiles;

    public FileSelectionPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        final Composite body = form.getBody();
        toolkit.decorateFormHeading(form.getForm());
        toolkit.paintBordersFor(body);
        managedForm.getForm().getBody().setLayout((Layout)new FillLayout(256));
        if (this.getFile() == null) {
            managedForm.getForm().setMessage("Suite file not located in workspace, Test File Selection might not be populated correctly.", 2);
        }
        Composite composite = managedForm.getToolkit().createComposite(managedForm.getForm().getBody(), 0);
        managedForm.getToolkit().paintBordersFor(composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        Section sctnInclusionexclusionPatterns = managedForm.getToolkit().createSection(composite, 258);
        final GridData gd_sctnInclusionexclusionPatterns = new GridData(4, 128, true, false, 1, 1);
        sctnInclusionexclusionPatterns.setLayoutData((Object)gd_sctnInclusionexclusionPatterns);
        managedForm.getToolkit().paintBordersFor((Composite)sctnInclusionexclusionPatterns);
        sctnInclusionexclusionPatterns.setText("Inclusion/Exclusion Patterns");
        sctnInclusionexclusionPatterns.setExpanded(false);
        sctnInclusionexclusionPatterns.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                gd_sctnInclusionexclusionPatterns.heightHint = e.getState() ? 200 : -1;
                body.layout(true, true);
            }
        });
        Composite composite_1 = managedForm.getToolkit().createComposite((Composite)sctnInclusionexclusionPatterns, 0);
        managedForm.getToolkit().paintBordersFor(composite_1);
        sctnInclusionexclusionPatterns.setClient((Control)composite_1);
        composite_1.setLayout((Layout)new GridLayout(2, false));
        managedForm.getToolkit().createLabel(composite_1, "Include patterns", 0);
        managedForm.getToolkit().createLabel(composite_1, "Exclude patterns", 0);
        this.fTxtIncludeFilters = managedForm.getToolkit().createText(composite_1, "", 2);
        this.fTxtIncludeFilters.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.fTxtExcludeFilters = managedForm.getToolkit().createText(composite_1, "", 2);
        this.fTxtExcludeFilters.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblAddAntStyle = managedForm.getToolkit().createLabel((Composite)sctnInclusionexclusionPatterns, "Add ANT style patterns to include and exclude files. First a list of included files will be generated, then exclude patterns get applied to that list.\n\nYou may use relative paths (relative to the suite file) and URIs (file://, workspace://, project://). Further * and ** wildcards are allowed.", 64);
        sctnInclusionexclusionPatterns.setDescriptionControl((Control)lblAddAntStyle);
        Section sctnTestFileSelection = managedForm.getToolkit().createSection(composite, 258);
        sctnTestFileSelection.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        managedForm.getToolkit().paintBordersFor((Composite)sctnTestFileSelection);
        sctnTestFileSelection.setText("Test File Selection");
        sctnTestFileSelection.setExpanded(true);
        Tree tree = managedForm.getToolkit().createTree((Composite)sctnTestFileSelection, 2080);
        managedForm.getToolkit().paintBordersFor((Composite)tree);
        sctnTestFileSelection.setClient((Control)tree);
        this.fTestFilesTreeViewer = new ContainerCheckedTreeViewer(tree);
        this.fTestFilesTreeViewer.setContentProvider((IContentProvider)new FileSelectionTreeProvider());
        this.fTestFilesTreeViewer.setLabelProvider((IBaseLabelProvider)new FileSelectionLabelProvider(this.getEditor().getResourceManager()));
        this.fTestFilesTreeViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                return element instanceof ITestFolder ? 0 : 1;
            }
        });
        this.fTestFilesTreeViewer.addDoubleClickListener(event -> {
            Object element;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof ITestFile) {
                Object resource = ((ITestFile)element).getResource();
                UnitTestView.openEditor(resource, 0);
            }
        });
        this.fTestFilesTreeViewer.setInput(null);
        Label lblUncheckFilesTo = managedForm.getToolkit().createLabel((Composite)sctnTestFileSelection, "Uncheck files to disable them for the test run.", 0);
        sctnTestFileSelection.setDescriptionControl((Control)lblUncheckFilesTo);
        this.populateContent();
        this.fTxtIncludeFilters.addFocusListener((FocusListener)new FocusAdapter(){
            private String fInitialContent;

            public void focusGained(FocusEvent e) {
                this.fInitialContent = FileSelectionPage.this.fTxtIncludeFilters.getText();
            }

            public void focusLost(FocusEvent e) {
                if (!FileSelectionPage.this.fTxtIncludeFilters.getText().equals(this.fInitialContent)) {
                    Command command = SetCommand.create((EditingDomain)FileSelectionPage.this.getEditingDomain(), (Object)FileSelectionPage.this.getTestSuiteDefinition(), (Object)IDefinitionPackage.Literals.TEST_SUITE_DEFINITION__INCLUDE_FILTER, (Object)FileSelectionPage.this.fTxtIncludeFilters.getText());
                    FileSelectionPage.this.getEditor().executeCommand(command);
                    FileSelectionPage.this.updateTestFiles();
                }
            }
        });
        this.fTxtExcludeFilters.addFocusListener((FocusListener)new FocusAdapter(){
            private String fInitialContent;

            public void focusGained(FocusEvent e) {
                this.fInitialContent = FileSelectionPage.this.fTxtExcludeFilters.getText();
            }

            public void focusLost(FocusEvent e) {
                if (!FileSelectionPage.this.fTxtExcludeFilters.getText().equals(this.fInitialContent)) {
                    Command command = SetCommand.create((EditingDomain)FileSelectionPage.this.getEditingDomain(), (Object)FileSelectionPage.this.getTestSuiteDefinition(), (Object)IDefinitionPackage.Literals.TEST_SUITE_DEFINITION__EXCLUDE_FILTER, (Object)FileSelectionPage.this.fTxtExcludeFilters.getText());
                    FileSelectionPage.this.getEditor().executeCommand(command);
                    FileSelectionPage.this.updateTestFiles();
                }
            }
        });
        this.fTestFilesTreeViewer.addCheckStateListener(event -> {
            Object element = event.getElement();
            if (element instanceof ITestEntity) {
                CompoundCommand compoundCommand = new CompoundCommand();
                this.populateModelUpdateForUncheckedTests(element, event.getChecked(), compoundCommand);
                this.getEditor().executeCommand((Command)compoundCommand);
            }
        });
    }

    private void populateModelUpdateForUncheckedTests(Object element, boolean checked, CompoundCommand compoundCommand) {
        if (element instanceof ITestContainer) {
            Command command;
            IPath entityPath = ((ITestContainer)element).getFullPath();
            if (this.getTestSuiteDefinition().getDisabledResources().contains((Object)entityPath) && checked) {
                command = RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getTestSuiteDefinition(), (Object)IDefinitionPackage.Literals.TEST_SUITE_DEFINITION__DISABLED_RESOURCES, (Object)entityPath);
                compoundCommand.append(command);
            } else if (!this.getTestSuiteDefinition().getDisabledResources().contains((Object)entityPath) && !checked) {
                command = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getTestSuiteDefinition(), (Object)IDefinitionPackage.Literals.TEST_SUITE_DEFINITION__DISABLED_RESOURCES, (Object)entityPath);
                compoundCommand.append(command);
            }
            for (ITestEntity child : ((ITestContainer)element).getChildren()) {
                this.populateModelUpdateForUncheckedTests(child, checked, compoundCommand);
            }
        }
    }

    @Override
    protected void populateContent() {
        this.fTxtIncludeFilters.setText(this.getTestSuiteDefinition().getIncludeFilter());
        this.fTxtExcludeFilters.setText(this.getTestSuiteDefinition().getExcludeFilter());
        this.updateTestFiles();
    }

    private void setCheckedState(ITestContainer element) {
        IPath entityPath = element.getFullPath();
        this.fTestFilesTreeViewer.setChecked((Object)element, !this.getTestSuiteDefinition().getDisabledResources().contains((Object)entityPath));
        for (ITestEntity child : element.getChildren()) {
            if (!(child instanceof ITestContainer)) continue;
            this.setCheckedState((ITestContainer)child);
        }
    }

    public void setActive(boolean active) {
        super.setActive(active);
        this.updateTestFiles();
    }

    public void updateTestFiles() {
        String[] includeFilters = this.fTxtIncludeFilters.getText().split("\r?\n");
        String[] excludeFilters = this.fTxtExcludeFilters.getText().split("\r?\n");
        if (this.getFile() != null) {
            Map acceptedFiles = UnitTestHelper.getTestFilesFromFilter((String[])includeFilters, (Object)this.getFile());
            this.fFilteredFiles = UnitTestHelper.getTestFilesFromFilter((String[])excludeFilters, (Object)this.getFile());
            acceptedFiles.keySet().removeAll(this.fFilteredFiles.keySet());
            List testStructure = UnitTestHelper.createTestStructure((Map)acceptedFiles);
            this.fTestFilesTreeViewer.setInput((Object)testStructure);
            this.fTestFilesTreeViewer.refresh();
            this.fTestFilesTreeViewer.expandAll();
            for (ITestEntity element : testStructure) {
                if (!(element instanceof ITestContainer)) continue;
                this.setCheckedState((ITestContainer)element);
            }
        }
    }

    @Override
    protected String getPageTitle() {
        return "Test Selection";
    }

    public Image getTitleImage() {
        return Activator.getImage("org.eclipse.ease.lang.unittest.ui", "/icons/eobj16/test_selection.png", true);
    }

    private class FileSelectionLabelProvider
    extends TestSuiteLabelProvider
    implements IFontProvider,
    IColorProvider {
        public FileSelectionLabelProvider(LocalResourceManager resourceManager) {
            super(resourceManager);
        }

        public Font getFont(Object element) {
            if (this.isRootElement(element)) {
                return FileSelectionPage.this.getEditor().getResourceManager().createFont((FontDescriptor)new StyledFontDescriptor(FileSelectionPage.this.fTestFilesTreeViewer.getTree().getFont(), 1));
            }
            if (element instanceof ITestFile && FileSelectionPage.this.fFilteredFiles.keySet().contains(((ITestFile)element).getResource())) {
                return FileSelectionPage.this.getEditor().getResourceManager().createFont((FontDescriptor)new StyledFontDescriptor(FileSelectionPage.this.fTestFilesTreeViewer.getTree().getFont(), 2));
            }
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof ITestFile && FileSelectionPage.this.fFilteredFiles.keySet().contains(((ITestFile)element).getResource())) {
                return Display.getDefault().getSystemColor(15);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    private class FileSelectionTreeProvider
    implements ITreeContentProvider {
        private FileSelectionTreeProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ITestContainer) {
                return ((ITestContainer)parentElement).getChildren().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ITestContainer) {
                return !((ITestContainer)element).getChildren().isEmpty();
            }
            return false;
        }
    }

    private class StyledFontDescriptor
    extends FontDescriptor {
        private final FontData[] fFontData;

        private StyledFontDescriptor(Font font, int style) {
            FontData[] fontDataArray = this.fFontData = font.getFontData();
            int n = this.fFontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData element = fontDataArray[n2];
                element.setStyle(element.getStyle() | style);
                ++n2;
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof StyledFontDescriptor) {
                StyledFontDescriptor desc = (StyledFontDescriptor)((Object)obj);
                if (desc.fFontData.length != this.fFontData.length) {
                    return false;
                }
                int i = 0;
                while (i < this.fFontData.length) {
                    if (!this.fFontData[i].equals((Object)desc.fFontData[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hash = 0;
            FontData[] fontDataArray = this.fFontData;
            int n = this.fFontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData element = fontDataArray[n2];
                hash = hash * 7 + element.hashCode();
                ++n2;
            }
            return hash;
        }

        public Font createFont(Device device) throws DeviceResourceException {
            return new Font(device, this.fFontData);
        }

        public void destroyFont(Font previouslyCreatedFont) {
            previouslyCreatedFont.dispose();
        }
    }
}

