/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.QRCode;

public final class MaskUtil {
    private MaskUtil() {
    }

    public static int applyMaskPenaltyRule1(ByteMatrix byteMatrix) {
        return MaskUtil.applyMaskPenaltyRule1Internal(byteMatrix, true) + MaskUtil.applyMaskPenaltyRule1Internal(byteMatrix, false);
    }

    public static int applyMaskPenaltyRule2(ByteMatrix byteMatrix) {
        int n = 0;
        byte[][] byArray = byteMatrix.getArray();
        int n2 = byteMatrix.getWidth();
        int n3 = byteMatrix.getHeight();
        for (int i = 0; i < n3 - 1; ++i) {
            for (int j = 0; j < n2 - 1; ++j) {
                byte by = byArray[i][j];
                if (by != byArray[i][j + 1] || by != byArray[i + 1][j] || by != byArray[i + 1][j + 1]) continue;
                n += 3;
            }
        }
        return n;
    }

    public static int applyMaskPenaltyRule3(ByteMatrix byteMatrix) {
        int n = 0;
        byte[][] byArray = byteMatrix.getArray();
        int n2 = byteMatrix.getWidth();
        int n3 = byteMatrix.getHeight();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (j + 6 < n2 && byArray[i][j] == 1 && byArray[i][j + 1] == 0 && byArray[i][j + 2] == 1 && byArray[i][j + 3] == 1 && byArray[i][j + 4] == 1 && byArray[i][j + 5] == 0 && byArray[i][j + 6] == 1 && (j + 10 < n2 && byArray[i][j + 7] == 0 && byArray[i][j + 8] == 0 && byArray[i][j + 9] == 0 && byArray[i][j + 10] == 0 || j - 4 >= 0 && byArray[i][j - 1] == 0 && byArray[i][j - 2] == 0 && byArray[i][j - 3] == 0 && byArray[i][j - 4] == 0)) {
                    n += 40;
                }
                if (i + 6 >= n3 || byArray[i][j] != 1 || byArray[i + 1][j] != 0 || byArray[i + 2][j] != 1 || byArray[i + 3][j] != 1 || byArray[i + 4][j] != 1 || byArray[i + 5][j] != 0 || byArray[i + 6][j] != 1 || (i + 10 >= n3 || byArray[i + 7][j] != 0 || byArray[i + 8][j] != 0 || byArray[i + 9][j] != 0 || byArray[i + 10][j] != 0) && (i - 4 < 0 || byArray[i - 1][j] != 0 || byArray[i - 2][j] != 0 || byArray[i - 3][j] != 0 || byArray[i - 4][j] != 0)) continue;
                n += 40;
            }
        }
        return n;
    }

    public static int applyMaskPenaltyRule4(ByteMatrix byteMatrix) {
        int n;
        int n2 = 0;
        byte[][] byArray = byteMatrix.getArray();
        int n3 = byteMatrix.getWidth();
        int n4 = byteMatrix.getHeight();
        for (n = 0; n < n4; ++n) {
            for (int i = 0; i < n3; ++i) {
                if (byArray[n][i] != 1) continue;
                ++n2;
            }
        }
        n = byteMatrix.getHeight() * byteMatrix.getWidth();
        double d = (double)n2 / (double)n;
        return Math.abs((int)(d * 100.0 - 50.0)) / 5 * 10;
    }

    public static boolean getDataMaskBit(int n, int n2, int n3) {
        int n4;
        if (!QRCode.isValidMaskPattern(n)) {
            throw new IllegalArgumentException("Invalid mask pattern");
        }
        switch (n) {
            case 0: {
                n4 = n3 + n2 & 1;
                break;
            }
            case 1: {
                n4 = n3 & 1;
                break;
            }
            case 2: {
                n4 = n2 % 3;
                break;
            }
            case 3: {
                n4 = (n3 + n2) % 3;
                break;
            }
            case 4: {
                n4 = (n3 >>> 1) + n2 / 3 & 1;
                break;
            }
            case 5: {
                int n5 = n3 * n2;
                n4 = (n5 & 1) + n5 % 3;
                break;
            }
            case 6: {
                int n6 = n3 * n2;
                n4 = (n6 & 1) + n6 % 3 & 1;
                break;
            }
            case 7: {
                int n7 = n3 * n2;
                n4 = n7 % 3 + (n3 + n2 & 1) & 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mask pattern: " + n);
            }
        }
        return n4 == 0;
    }

    private static int applyMaskPenaltyRule1Internal(ByteMatrix byteMatrix, boolean bl) {
        int n = 0;
        int n2 = 0;
        byte by = -1;
        int n3 = bl ? byteMatrix.getHeight() : byteMatrix.getWidth();
        int n4 = bl ? byteMatrix.getWidth() : byteMatrix.getHeight();
        byte[][] byArray = byteMatrix.getArray();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                byte by2;
                byte by3 = by2 = bl ? byArray[i][j] : byArray[j][i];
                if (by2 == by) {
                    if (++n2 == 5) {
                        n += 3;
                        continue;
                    }
                    if (n2 <= 5) continue;
                    ++n;
                    continue;
                }
                n2 = 1;
                by = by2;
            }
            n2 = 0;
        }
        return n;
    }
}

