#!perl

use strict;
use warnings;

use Test::More tests => 11;
use Test::Regexp::Pattern;

use Regexp::Pattern;

my $re = re( 'License::beerware', subject => 'name', engine => 'PCRE2' );

isa_ok( $re, 're::engine::PCRE2' );
is( "$re", '(?:$the?[Bb]eer$D?ware(?: License)?)' );

regexp_patterns_in_module_ok(
	'Regexp::Pattern::License',
	{ engine => 'PCRE2' }, 'using PCRE2'
);

regexp_patterns_in_module_ok(
	'Regexp::Pattern::License::Parts',
	{ engine => 'PCRE2' }, 'parts using PCRE2'
);

# subject
regexp_patterns_in_module_ok(
	'Regexp::Pattern::License',
	{ engine => 'PCRE2', subject => 'name' },
	'using PCRE2 with subject name'
);
regexp_patterns_in_module_ok(
	'Regexp::Pattern::License',
	{ engine => 'PCRE2', subject => 'grant' },
	'using PCRE2 with subject grant'
);
regexp_patterns_in_module_ok(
	'Regexp::Pattern::License',
	{ engine => 'PCRE2', subject => 'license' },
	'using PCRE2 with subject license'
);
regexp_patterns_in_module_ok(
	'Regexp::Pattern::License',
	{ engine => 'PCRE2', subject => 'iri' },
	'using PCRE2 with subject iri'
);

# capture
regexp_patterns_in_module_ok(
	'Regexp::Pattern::License',
	{ engine => 'PCRE2', capture => 'named' },
	'using PCRE2 with named capture'
);
regexp_patterns_in_module_ok(
	'Regexp::Pattern::License',
	{ engine => 'PCRE2', capture => 'numbered' },
	'using PCRE2 with numbered capture'
);
regexp_patterns_in_module_ok(
	'Regexp::Pattern::License',
	{ engine => 'PCRE2', capture => 'no' },
	'using PCRE2 without capture'
);
