%global _name          razor-torquebox
%global realversion    3.1.1-3
%global rpmversion     3.1.1.3

# For better or worse, there are a bunch of different arch binaries in this.
# They get loaded and managed by Java and the app stack without our
# intervention, so we should allow them without termination.
%define _binaries_in_noarch_packages_terminate_build   0

Summary:        TorqueBox is a Ruby/JBoss application application platform
Name:           %{_name}
Version:        %{rpmversion}
Release:        1%{?dist}
Vendor:         Puppet Labs
License:        Various: GNU LGPL and MIT
Group:          System Environment/Base
URL:            http://www.puppetlabs.com/puppet/related-projects/%{name}
# Note this     URL will only be valid at official tags from Puppet Labs
Source0:        http://puppetlabs.com/downloads/%{name}/%{name}-%{realversion}.tar.gz
BuildArch:      noarch
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
AutoProv:       0

# @todo danielp 2014-01-10: for some reason this results in a dependency on
# `config(razor-torquebox) = %{version}`, which I can't figure out.  Whatever.
AutoReqProv:    0
Requires:       /bin/sh
Requires:       /usr/bin/env
# This one is not auto-detected either way.
Requires:       java >= 1.6

%description
TorqueBox is a new kind of Ruby application platform that supports popular
technologies such as Ruby on Rails and Sinatra, while extending the
footprint of Ruby applications to include built-in support for services such
as messaging, scheduling, caching, and daemons.

TorqueBox provides an all-in-one environment, built upon the latest JBoss AS
Java application server and JRuby. Functionality such as clustering,
load-balancing and high-availability is included right out-of-the-box.

This package of TorqueBox is intended for use with the Razor server, but has
no modifications from the stock TorqueBox, and is used under their license.


%prep
%setup -q -n %{name}-%{realversion}

%build
: nothing to be done

%install
rm -rf %{buildroot}

# Install the binary distribution.
mkdir -p %{buildroot}/opt
unzip -q -d %{buildroot}/opt torquebox-dist-3.1.1-bin.zip
mv %{buildroot}/opt/torquebox-3.1.1 %{buildroot}/opt/razor-torquebox

# Install a nicer, more generic way for consumers of this to interact with it,
# so they don't have to hard-code our paths -- and we can fix them later by
# bumping this package without touching everything that depends on it.
mkdir -p %{buildroot}/etc/razor
cp razor-torquebox.sh %{buildroot}/etc/razor

# Move the home directory out into a more FHS-compliant location
mkdir -p %{buildroot}/var/lib/razor
mv %{buildroot}/opt/razor-torquebox/jboss/standalone %{buildroot}/var/lib/razor-torquebox
ln -s /var/lib/razor-torquebox %{buildroot}/opt/razor-torquebox/jboss/standalone

%clean
rm -rf %{buildroot}

%pre -p /bin/bash
getent group razor >/dev/null || groupadd -r razor
getent passwd razor >/dev/null || \
    useradd -r -g razor -d /var/lib/razor -s /bin/bash \
    -c "Razor service account" razor
exit 0

%files
%defattr(-,root,root,-)
/opt/razor-torquebox
%attr(-,razor,razor) /var/lib/razor-torquebox
%config /etc/razor/razor-torquebox.sh

%changelog
* Wed Jan 14 2015 Puppet Labs Release <info@puppetlabs.com> -  3.1.1.3-1
- Build for 3.1.1-3
