/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import java.util.logging.Formatter;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;

public class SyslogHandler
extends ExtHandler {
    public static final InetAddress DEFAULT_ADDRESS;
    public static final int DEFAULT_PORT = 514;
    public static final Facility DEFAULT_FACILITY;
    public static final char NILVALUE = '-';
    private static final String ENCODING = "utf-8";
    private final Object outputLock = new Object();
    private InetAddress serverAddress;
    private int port;
    private String appName;
    private String hostname;
    private volatile Facility facility;
    private SyslogType syslogType;
    private final DatagramSocket datagramSocket;
    private final String pid;

    public SyslogHandler() throws IOException {
        this(DEFAULT_ADDRESS, 514);
    }

    public SyslogHandler(String serverHostname, int port) throws IOException {
        this(serverHostname, port, DEFAULT_FACILITY, null);
    }

    public SyslogHandler(InetAddress serverAddress, int port) throws IOException {
        this(serverAddress, port, DEFAULT_FACILITY, null);
    }

    public SyslogHandler(String serverHostname, int port, Facility facility, String hostname) throws IOException {
        this(serverHostname, port, facility, null, hostname);
    }

    public SyslogHandler(InetAddress serverAddress, int port, Facility facility, String hostname) throws IOException {
        this(serverAddress, port, facility, null, hostname);
    }

    public SyslogHandler(String serverHostname, int port, Facility facility, SyslogType syslogType, String hostname) throws IOException {
        this(InetAddress.getByName(serverHostname), port, facility, syslogType, hostname);
    }

    public SyslogHandler(InetAddress serverAddress, int port, Facility facility, SyslogType syslogType, String hostname) throws IOException {
        this.serverAddress = serverAddress;
        this.port = port;
        this.facility = facility;
        this.datagramSocket = new DatagramSocket();
        this.pid = SyslogHandler.findPid();
        this.appName = "java";
        this.hostname = hostname;
        this.syslogType = syslogType == null ? SyslogType.RFC5424 : syslogType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void doPublish(ExtLogRecord record) {
        if (record.getMessage() == null || record.getMessage().isEmpty()) {
            return;
        }
        Object object = this.outputLock;
        synchronized (object) {
            if (this.datagramSocket.isClosed()) {
                throw new IllegalStateException("The syslog handler has been closed.");
            }
            try {
                String message = this.syslogType.format(record, this.facility, this.hostname, this.pid, this.appName);
                DatagramPacket dp = new DatagramPacket(message.getBytes(), message.length(), this.serverAddress, this.port);
                this.datagramSocket.send(dp);
            }
            catch (IOException e) {
                this.reportError("Could not write to syslog", e, 1);
            }
        }
        super.doPublish(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.outputLock;
        synchronized (object) {
            SyslogHandler.safeClose(this.datagramSocket);
        }
        super.close();
    }

    @Override
    public void setFormatter(Formatter newFormatter) throws SecurityException {
        super.setFormatter(newFormatter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAppName() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.appName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppName(String appName) {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.appName = appName;
        }
    }

    public String getPid() {
        return this.pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int port) {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.port = port;
        }
    }

    public Facility getFacility() {
        return this.facility;
    }

    public void setFacility(Facility facility) {
        SyslogHandler.checkAccess(this);
        this.facility = facility;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        if (hostname != null && hostname.contains(" ")) {
            throw new IllegalArgumentException(String.format("Host name '%s' is invalid. Whitespace is now allowed in the host name.", hostname));
        }
        this.hostname = hostname;
    }

    public void setServerHostname(String hostname) throws UnknownHostException {
        SyslogHandler.checkAccess(this);
        this.setServerAddress(InetAddress.getByName(hostname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getServerAddress() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.serverAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerAddress(InetAddress serverAddress) {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.serverAddress = serverAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyslogType getSyslogType() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.syslogType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyslogType(SyslogType syslogType) {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.syslogType = syslogType;
        }
    }

    static void safeClose(DatagramSocket datagramSocket) {
        if (datagramSocket != null) {
            try {
                if (!datagramSocket.isClosed()) {
                    datagramSocket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String findPid() {
        String name;
        String result = name = ManagementFactory.getRuntimeMXBean().getName();
        int index = name.indexOf("@");
        if (index > -1) {
            try {
                result = Integer.toString(Integer.valueOf(name.substring(0, index - 1)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    static {
        DEFAULT_FACILITY = Facility.USER_LEVEL;
        try {
            DEFAULT_ADDRESS = InetAddress.getByName("localhost");
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Could not create address to localhost");
        }
    }

    public static enum SyslogType {
        RFC5424{

            @Override
            protected String format(ExtLogRecord record, Facility facility, String hostname, String pid, String appName) throws UnsupportedEncodingException {
                StringBuilder message = new StringBuilder();
                message.append('<').append(1.calculatePriority(record.getLevel(), facility)).append('>');
                message.append("1 ");
                long millis = record.getMillis();
                if (millis <= 0L) {
                    message.append('-').append(' ');
                } else {
                    1.formatDate(this, millis, message);
                }
                message.append(' ');
                if (hostname == null) {
                    message.append('-').append(' ');
                } else {
                    message.append(hostname).append(' ');
                }
                if (appName == null) {
                    message.append('-').append(' ');
                } else {
                    message.append(appName).append(' ');
                }
                if (pid == null) {
                    message.append('-').append(' ');
                } else {
                    message.append(pid).append(' ');
                }
                String msgid = record.getLoggerName();
                if (msgid == null || msgid.isEmpty()) {
                    message.append('-').append(' ');
                } else {
                    message.append(msgid).append(' ');
                }
                message.append('-').append(' ');
                message.append(new String(record.getFormattedMessage().getBytes(SyslogHandler.ENCODING), SyslogHandler.ENCODING));
                return message.toString();
            }
        }
        ,
        RFC3164{

            @Override
            protected String format(ExtLogRecord record, Facility facility, String hostname, String pid, String appName) throws UnsupportedEncodingException {
                StringBuilder message = new StringBuilder();
                message.append('<').append(2.calculatePriority(record.getLevel(), facility)).append('>');
                long millis = record.getMillis();
                2.formatDate(this, millis <= 0L ? System.currentTimeMillis() : millis, message);
                message.append(' ');
                if (hostname == null) {
                    message.append("UNKNOWN_HOSTNAME").append(' ');
                } else {
                    message.append(hostname).append(' ');
                }
                if (appName != null && pid != null) {
                    message.append(appName).append("[").append(pid).append("]").append(": ");
                } else if (appName != null) {
                    message.append(appName).append(": ");
                } else if (pid != null) {
                    message.append("[").append(pid).append("]").append(": ");
                }
                message.append(new String(record.getFormattedMessage().getBytes(SyslogHandler.ENCODING), SyslogHandler.ENCODING));
                if (message.length() > 1024) {
                    return message.substring(0, 1024);
                }
                return message.toString();
            }
        };


        protected abstract String format(ExtLogRecord var1, Facility var2, String var3, String var4, String var5) throws UnsupportedEncodingException;

        protected static int calculatePriority(java.util.logging.Level level, Facility facility) {
            Severity severity = Severity.fromLevel(level);
            return facility.octal | severity.code;
        }

        protected static void formatDate(SyslogType syslogType, long millis, StringBuilder buffer) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(millis);
            int month = cal.get(2);
            int day = cal.get(5);
            int hours = cal.get(11);
            int minutes = cal.get(12);
            int seconds = cal.get(13);
            switch (syslogType) {
                case RFC5424: {
                    buffer.append(cal.get(1)).append('-');
                    if (month < 10) {
                        buffer.append(0);
                    }
                    buffer.append(month + 1).append('-');
                    if (day < 10) {
                        buffer.append(0);
                    }
                    buffer.append(day).append('T');
                    if (hours < 10) {
                        buffer.append(0);
                    }
                    buffer.append(hours).append(':');
                    if (minutes < 10) {
                        buffer.append(0);
                    }
                    buffer.append(minutes).append(':');
                    if (seconds < 10) {
                        buffer.append(0);
                    }
                    buffer.append(seconds).append('.');
                    int milliseconds = cal.get(14);
                    if (milliseconds < 10) {
                        buffer.append(0).append(0);
                    } else if (milliseconds < 100) {
                        buffer.append(0);
                    }
                    buffer.append(milliseconds);
                    int tz = cal.get(15) + cal.get(16);
                    if (tz == 0) {
                        buffer.append("+00:00");
                        break;
                    }
                    int tzMinutes = tz / 60000;
                    if (tzMinutes < 0) {
                        tzMinutes = -tzMinutes;
                        buffer.append('-');
                    } else {
                        buffer.append('+');
                    }
                    int tzHour = tzMinutes / 60;
                    tzMinutes -= tzHour * 60;
                    if (tzHour < 10) {
                        buffer.append(0);
                    }
                    buffer.append(tzHour).append(':');
                    if (tzMinutes < 10) {
                        buffer.append(0);
                    }
                    buffer.append(tzMinutes);
                    break;
                }
                case RFC3164: {
                    DateFormatSymbols formatSymbols = DateFormatSymbols.getInstance(Locale.ENGLISH);
                    buffer.append(formatSymbols.getShortMonths()[month]).append(' ');
                    if (day < 10) {
                        buffer.append(' ');
                    }
                    buffer.append(day).append(' ');
                    if (hours < 10) {
                        buffer.append(0);
                    }
                    buffer.append(hours).append(':');
                    if (minutes < 10) {
                        buffer.append(0);
                    }
                    buffer.append(minutes).append(':');
                    if (seconds < 10) {
                        buffer.append(0);
                    }
                    buffer.append(seconds);
                    break;
                }
            }
        }
    }

    public static enum Facility {
        KERNEL(0, "kernel messages"),
        USER_LEVEL(1, "user-level messages"),
        MAIL_SYSTEM(2, "mail system"),
        SYSTEM_DAEMONS(3, "system daemons"),
        SECURITY(4, "security/authorization messages"),
        SYSLOGD(5, "messages generated internally by syslogd"),
        LINE_PRINTER(6, "line printer subsystem"),
        NETWORK_NEWS(7, "network news subsystem"),
        UUCP(8, "UUCP subsystem"),
        CLOCK_DAEMON(9, "clock daemon"),
        SECURITY2(10, "security/authorization messages"),
        FTP_DAEMON(11, "FTP daemon"),
        NTP(12, "NTP subsystem"),
        LOG_AUDIT(13, "log audit"),
        LOG_ALERT(14, "log alert"),
        CLOCK_DAEMON2(15, "clock daemon (note 2)"),
        LOCAL_USE_0(16, "local use 0  (local0)"),
        LOCAL_USE_1(17, "local use 1  (local1)"),
        LOCAL_USE_2(18, "local use 2  (local2)"),
        LOCAL_USE_3(19, "local use 3  (local3)"),
        LOCAL_USE_4(20, "local use 4  (local4)"),
        LOCAL_USE_5(21, "local use 5  (local5)"),
        LOCAL_USE_6(22, "local use 6  (local6)"),
        LOCAL_USE_7(23, "local use 7  (local7)");

        final int code;
        final String desc;
        final int octal;

        private Facility(int code, String desc) {
            this.code = code;
            this.desc = desc;
            this.octal = code * 8;
        }

        public String toString() {
            return String.format("%s[%d,%s]", this.name(), this.code, this.desc);
        }
    }

    public static enum Severity {
        EMERGENCY(0, "Emergency: system is unusable"),
        ALERT(1, "Alert: action must be taken immediately"),
        CRITICAL(2, "Critical: critical conditions"),
        ERROR(3, "Error: error conditions"),
        WARNING(4, "Warning: warning conditions"),
        NOTICE(5, "Notice: normal but significant condition"),
        INFORMATIONAL(6, "Informational: informational messages"),
        DEBUG(7, "Debug: debug-level messages");

        final int code;
        final String desc;

        private Severity(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String toString() {
            return String.format("%s[%d,%s]", this.name(), this.code, this.desc);
        }

        public static Severity fromLevel(java.util.logging.Level level) {
            if (level == null) {
                throw new IllegalArgumentException("Level cannot be null");
            }
            int levelValue = level.intValue();
            if (levelValue >= Level.FATAL.intValue()) {
                return EMERGENCY;
            }
            if (levelValue >= Level.SEVERE.intValue() || levelValue >= Level.ERROR.intValue()) {
                return ERROR;
            }
            if (levelValue >= Level.WARN.intValue() || levelValue >= java.util.logging.Level.WARNING.intValue()) {
                return WARNING;
            }
            if (levelValue >= Level.INFO.intValue()) {
                return INFORMATIONAL;
            }
            if (levelValue >= Level.TRACE.intValue() || levelValue >= java.util.logging.Level.FINEST.intValue()) {
                return DEBUG;
            }
            return INFORMATIONAL;
        }
    }
}

