/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.core.gem;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class MSCServiceListener
extends AbstractServiceListener<Object> {
    private CountDownLatch startLatch = new CountDownLatch(1);
    private ServiceController<?> controller;

    public MSCServiceListener(ServiceController<?> controller) {
        this.controller = controller;
    }

    public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
        ServiceController.Substate after = transition.getAfter();
        if (after == ServiceController.Substate.UP || after == ServiceController.Substate.CANCELLED || after == ServiceController.Substate.WONT_START || after == ServiceController.Substate.PROBLEM || after == ServiceController.Substate.START_FAILED || after == ServiceController.Substate.STOP_REQUESTED || after == ServiceController.Substate.STOPPING || after == ServiceController.Substate.REMOVING || after == ServiceController.Substate.REMOVED) {
            this.notifyAsStartedOrProblem();
            controller.removeListener((ServiceListener)this);
        }
    }

    void notifyAsStartedOrProblem() {
        this.startLatch.countDown();
    }

    public boolean waitForStartOrFailure(long secondsToWait) throws InterruptedException {
        if (this.isUp()) {
            return true;
        }
        this.startLatch.await(secondsToWait, TimeUnit.SECONDS);
        return this.isUp();
    }

    public boolean isUp() {
        return this.controller.getState() == ServiceController.State.UP;
    }

    public Object getValue() {
        return this.controller.getValue();
    }

    public String toString() {
        return "[MSCServiceListener: controller=" + this.controller + "; state=" + this.controller.getState() + "; substate=" + this.controller.getSubstate() + "]";
    }
}

