/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core.management;

import org.hornetq.utils.json.JSONObject;

public final class AddressSettingsInfo {
    private final String addressFullMessagePolicy;
    private final long maxSizeBytes;
    private final int pageSizeBytes;
    private int pageCacheMaxSize;
    private final int maxDeliveryAttempts;
    private final double redeliveryMultiplier;
    private final long maxRedeliveryDelay;
    private final long redeliveryDelay;
    private final String deadLetterAddress;
    private final String expiryAddress;
    private final boolean lastValueQueue;
    private final long redistributionDelay;
    private final boolean sendToDLAOnNoRoute;

    public static final AddressSettingsInfo from(String jsonString) throws Exception {
        JSONObject object = new JSONObject(jsonString);
        return new AddressSettingsInfo(object.getString("addressFullMessagePolicy"), object.getLong("maxSizeBytes"), object.getInt("pageSizeBytes"), object.getInt("pageCacheMaxSize"), object.getInt("maxDeliveryAttempts"), object.getLong("redeliveryDelay"), object.getDouble("redeliveryMultiplier"), object.getLong("maxRedeliveryDelay"), object.getString("DLA"), object.getString("expiryAddress"), object.getBoolean("lastValueQueue"), object.getLong("redistributionDelay"), object.getBoolean("sendToDLAOnNoRoute"));
    }

    public AddressSettingsInfo(String addressFullMessagePolicy, long maxSizeBytes, int pageSizeBytes, int pageCacheMaxSize, int maxDeliveryAttempts, long redeliveryDelay, double redeliveryMultiplier, long maxRedeliveryDelay, String deadLetterAddress, String expiryAddress, boolean lastValueQueue, long redistributionDelay, boolean sendToDLAOnNoRoute) {
        this.addressFullMessagePolicy = addressFullMessagePolicy;
        this.maxSizeBytes = maxSizeBytes;
        this.pageSizeBytes = pageSizeBytes;
        this.pageCacheMaxSize = pageCacheMaxSize;
        this.maxDeliveryAttempts = maxDeliveryAttempts;
        this.redeliveryDelay = redeliveryDelay;
        this.redeliveryMultiplier = redeliveryMultiplier;
        this.maxRedeliveryDelay = maxRedeliveryDelay;
        this.deadLetterAddress = deadLetterAddress;
        this.expiryAddress = expiryAddress;
        this.lastValueQueue = lastValueQueue;
        this.redistributionDelay = redistributionDelay;
        this.sendToDLAOnNoRoute = sendToDLAOnNoRoute;
    }

    public int getPageCacheMaxSize() {
        return this.pageCacheMaxSize;
    }

    public void setPageCacheMaxSize(int pageCacheMaxSize) {
        this.pageCacheMaxSize = pageCacheMaxSize;
    }

    public String getAddressFullMessagePolicy() {
        return this.addressFullMessagePolicy;
    }

    public long getMaxSizeBytes() {
        return this.maxSizeBytes;
    }

    public int getPageSizeBytes() {
        return this.pageSizeBytes;
    }

    public int getMaxDeliveryAttempts() {
        return this.maxDeliveryAttempts;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    public String getDeadLetterAddress() {
        return this.deadLetterAddress;
    }

    public String getExpiryAddress() {
        return this.expiryAddress;
    }

    public boolean isLastValueQueue() {
        return this.lastValueQueue;
    }

    public long getRedistributionDelay() {
        return this.redistributionDelay;
    }

    public boolean isSendToDLAOnNoRoute() {
        return this.sendToDLAOnNoRoute;
    }

    public double getRedeliveryMultiplier() {
        return this.redeliveryMultiplier;
    }

    public long getMaxRedeliveryDelay() {
        return this.maxRedeliveryDelay;
    }
}

