/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core;

import org.hornetq.api.core.HornetQExceptionType;

public class HornetQException
extends Exception {
    private static final long serialVersionUID = -4802014152804997417L;
    private final HornetQExceptionType type;

    public HornetQException() {
        this.type = HornetQExceptionType.GENERIC_EXCEPTION;
    }

    public HornetQException(String msg) {
        super(msg);
        this.type = HornetQExceptionType.GENERIC_EXCEPTION;
    }

    public HornetQException(int code, String msg) {
        super(msg);
        this.type = HornetQExceptionType.getType(code);
    }

    public HornetQException(HornetQExceptionType type, String msg) {
        super(msg);
        this.type = type;
    }

    public HornetQException(HornetQExceptionType type) {
        this.type = type;
    }

    public HornetQException(HornetQExceptionType type, String message, Throwable t) {
        super(message, t);
        this.type = type;
    }

    public HornetQExceptionType getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return "HornetQException[errorType=" + (Object)((Object)this.type) + " message=" + this.getMessage() + "]";
    }
}

