# Only >=el7 and fedora have a sufficient version of ruby available
%if 0%{?rhel} >= 7 || 0%{?fedora}
%{!?vendor_ruby: %global vendor_ruby %(ruby -rrbconfig -e "puts RbConfig::CONFIG['vendordir']")}
%endif

# Building debuginfo is pointless, as this has no symbols.
%global debug_package %{nil}

# VERSION is subbed out during rake srpm process
%global realversion 0.3.0
%global rpmversion 0.3.0

%global build_prefix /opt/pl-build-tools
%global _prefix /usr
%global _libdir %{_prefix}/lib

Name:           cfacter
Summary:        Ruby module for collecting simple facts about a host operating system
Version:        %{rpmversion}
Release:        1%{?dist}
Vendor:         %{?_host_vendor}
License:        ASL 2.0
Group:          System Environment/Base
URL:            http://www.puppetlabs.com/puppet/related-projects/%{name}
# Note this     URL will only be valid at official tags from Puppet Labs
Source0:        http://puppetlabs.com/downloads/%{name}/%{name}-%{realversion}.tar.gz

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

# Only >=el7 and fedora have a sufficient version of ruby available
%if 0%{?rhel} >= 7 || 0%{?fedora}
BuildRequires:  ruby
BuildRequires:  ruby-devel
%endif
BuildRequires:  pl-gcc >= 4.8.2-4
BuildRequires:  pl-cmake >= 2.8.12-6
BuildRequires:  pl-libboost-devel >= 1.55.0-4
BuildRequires:  pl-libboost-static >= 1.55.0-4
BuildRequires:  pl-libyaml-cpp-devel >= 0.5.1-5
BuildRequires:  pl-libyaml-cpp-static >= 0.5.1-5

%if 0%{?rhel} > 5
BuildRequires:  openssl-devel
BuildRequires:  libblkid-devel
BuildRequires:  libcurl-devel
%endif

Requires: glibc
%if 0%{?rhel} > 5
Requires: libblkid
Requires: libcurl
%endif
# If we're linking against openssl, we need to ensure those libraries are available
# during runtime. On EL7, those dependency libraries are available via the openssl-libs
# package, but we don't have that package on earlier versions. We want to install as
# few extra packages as possible, which is why we're installing openssl-libs when available.
%if 0%{?rhel} >= 7
Requires: openssl-libs
%endif
%if 0%{?rhel} == 6
Requires: openssl
%endif

AutoReq:  0
AutoProv: 0

%description
Ruby module for collecting simple facts about a host Operating
system. Some of the facts are preconfigured, such as the hostname and the
operating system. Additional facts can be added through simple Ruby scripts

%prep
%setup -q  -n %{name}-%{realversion}

%build
rm -rf %{buildroot}
%{build_prefix}/bin/cmake \
  -DCMAKE_TOOLCHAIN_FILE=%{build_prefix}/pl-build-toolchain.cmake \
  -DCMAKE_VERBOSE_MAKEFILE=ON \
  -DCMAKE_INSTALL_PREFIX=%{_prefix} \
  -DBOOST_STATIC=ON \
  -DYAMLCPP_STATIC=ON \
  .
  make %{?_smp_mflags} DESTDIR=%{buildroot}

%install
make %{?_smp_mflags} install DESTDIR=%{buildroot}

# These files are needed at buildtime, but not at runtime
rm -r %{buildroot}%{_includedir}/boost

%clean
rm -rf %{buildroot}

%check
%{build_prefix}/bin/ctest -V

%files
%defattr(-,root,root,-)
%{_bindir}/cfacter
%{_libdir}/libfacter.so*
%{_includedir}/facter
%if 0%{?rhel} >= 7 || 0%{?fedora}
%{vendor_ruby}/cfacter.rb
%endif
%doc LICENSE README.md


%changelog
* Mon Feb 02 2015 Puppet Labs Release <info@puppetlabs.com> - 0.3.0-1
- Build for 0.3.0

* Thu Jun 05 2014 Melissa Stone <melissa@puppetlabs.com> - 1.7.2-1
- Initial build of cFacter
